/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.admob_adapter;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import com.amazon.admob_adapter.APSAdMobAdapterUtil;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsResult;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdBannerListener;
import com.amazon.device.ads.DTBAdCallback;
import com.amazon.device.ads.DTBAdInterstitial;
import com.amazon.device.ads.DTBAdInterstitialListener;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DTBCacheData;
import com.amazon.device.ads.DTBLoadException;
import com.amazon.device.ads.DtbCommonUtils;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import java.util.Set;

class APSAdMobUtil {
    private DTBAdInterstitial interstitial;
    private static final String LOGTAG = APSAdMobUtil.class.getSimpleName();

    APSAdMobUtil() {
    }

    void loadBannerAd(final Context context, final CustomEventBannerListener listener, final AdSize adSize, Bundle customEventExtras, final String serverParameter, Set<String> autoRefreshRequestIds, final DTBAdBannerListener bannerListener, final ApsMetricsPerfEventModelBuilder metricsBuilder, final String correlationId) {
        String slotGroup = customEventExtras.getString("amazon_custom_event_slot_group");
        String slotUUID = customEventExtras.getString("amazon_custom_event_slot_uuid");
        int width = customEventExtras.getInt("amazon_custom_event_width");
        int height = customEventExtras.getInt("amazon_custom_event_height");
        final String requestId = customEventExtras.getString("amazon_custom_event_request_id");
        if (DtbCommonUtils.isNullOrEmpty((String)customEventExtras.getString("amazon_custom_event_request_id"))) {
            ApsLog.e((String)LOGTAG, (String)"Fail to load custom banner ad in loadBannerAd because no request id found");
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
            listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in loadBannerAd because no request id found", "com.amazon.device.ads"));
            return;
        }
        if (!DtbCommonUtils.isNullOrEmpty((String)slotGroup)) {
            DTBAdRequest dtbAdRequest = APSAdMobAdapterUtil.createDtbAdRequest(customEventExtras);
            dtbAdRequest.setCorrelationId(correlationId);
            dtbAdRequest.setSlotGroup(slotGroup);
            if (autoRefreshRequestIds.contains(requestId)) {
                dtbAdRequest.setRefreshFlag(true);
            } else {
                autoRefreshRequestIds.add(requestId);
            }
            final DTBCacheData dtbCacheData = new DTBCacheData(requestId, dtbAdRequest);
            AdRegistration.addAdMobCache((String)requestId, (DTBCacheData)dtbCacheData);
            try {
                dtbAdRequest.loadSmartBanner(new DTBAdCallback(){

                    public void onFailure(@NonNull com.amazon.device.ads.AdError adError) {
                        ApsLog.e((String)LOGTAG, (String)("Failed to load the smart ad; " + adError.getMessage()));
                        dtbCacheData.setBidRequestFailed(true);
                        ApsMetrics.Companion.adapterEvent(null, metricsBuilder);
                        listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in loadBannerAd", "com.amazon.device.ads"));
                    }

                    public void onSuccess(@NonNull DTBAdResponse dtbAdResponse) {
                        Log.i((String)LOGTAG, (String)" Load the smart ad successfully");
                        dtbCacheData.addResponse(dtbAdResponse);
                        metricsBuilder.withBidId(dtbAdResponse.getBidId());
                        ApsMetrics.Companion.adapterEvent(dtbAdResponse.getBidId(), metricsBuilder);
                        Bundle renderingBundle = dtbAdResponse.getRenderingBundle(true);
                        APSAdMobUtil.this.renderAPSBannerAds(context, listener, adSize, serverParameter, renderingBundle, requestId, bannerListener, metricsBuilder, correlationId);
                    }
                });
                APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Success, metricsBuilder, correlationId);
            }
            catch (DTBLoadException e) {
                ApsLog.e((String)LOGTAG, (String)("Fail to execute loadBannerAd method for rendering smart banner ad in APSAdMobCustomBannerEvent class " + (Object)((Object)e)));
                APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
                listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in requestBannerAd in APSAdMobCustomBannerEvent class", "com.amazon.device.ads"));
            }
        } else if (!DtbCommonUtils.isNullOrEmpty((String)slotUUID) && width > 0 && height > 0) {
            DTBAdRequest dtbAdRequest = APSAdMobAdapterUtil.createDtbAdRequest(customEventExtras);
            dtbAdRequest.setCorrelationId(correlationId);
            dtbAdRequest.setSizes(new DTBAdSize[]{new DTBAdSize(width, height, slotUUID)});
            if (autoRefreshRequestIds.contains(requestId)) {
                dtbAdRequest.setRefreshFlag(true);
            } else {
                autoRefreshRequestIds.add(requestId);
            }
            final DTBCacheData dtbCacheData = new DTBCacheData(requestId, dtbAdRequest);
            AdRegistration.addAdMobCache((String)requestId, (DTBCacheData)dtbCacheData);
            dtbAdRequest.loadAd(new DTBAdCallback(){

                public void onFailure(@NonNull com.amazon.device.ads.AdError adError) {
                    ApsLog.e((String)LOGTAG, (String)("Failed to load the ad; " + adError.getMessage()));
                    dtbCacheData.setBidRequestFailed(true);
                    ApsMetrics.Companion.adapterEvent(null, metricsBuilder);
                    listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in requestBannerAd in APSAdMobCustomBannerEvent class", "com.amazon.device.ads"));
                }

                public void onSuccess(@NonNull DTBAdResponse dtbAdResponse) {
                    ApsLog.i((String)LOGTAG, (String)" Load the smart ad successfully in APSAdMobCustomBannerEvent class");
                    dtbCacheData.addResponse(dtbAdResponse);
                    Bundle renderingBundle = dtbAdResponse.getRenderingBundle(false);
                    metricsBuilder.withBidId(dtbAdResponse.getBidId());
                    ApsMetrics.Companion.adapterEvent(dtbAdResponse.getBidId(), metricsBuilder);
                    APSAdMobUtil.this.renderAPSBannerAds(context, listener, adSize, serverParameter, renderingBundle, requestId, bannerListener, metricsBuilder, correlationId);
                }
            });
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Success, metricsBuilder, correlationId);
        } else {
            ApsLog.e((String)LOGTAG, (String)"Fail to execute loadBannerAd method because not have sufficient info");
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
            listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in loadBannerAd", "com.amazon.device.ads"));
        }
    }

    static void captureAdapterEndEvent(ApsMetricsResult result, ApsMetricsPerfEventModelBuilder metricsBuilder, String correlationId) {
        if (result != null) {
            metricsBuilder.withAdapterEndTime(result, System.currentTimeMillis());
            metricsBuilder.withCorrelationId(correlationId);
            if (result == ApsMetricsResult.Failure) {
                ApsMetrics.Companion.adapterEvent(null, metricsBuilder);
            }
        }
    }

    void renderAPSBannerAds(Context context, CustomEventBannerListener listener, AdSize adSize, String serverParameter, Bundle renderingBundle, String requestId, DTBAdBannerListener bannerListener, ApsMetricsPerfEventModelBuilder metricsBuilder, String correlationId) {
        if (DTBAdUtil.validateSinglePriceAdMobCustomEvent((String)serverParameter, (Bundle)renderingBundle)) {
            DTBAdView adView = new DTBAdView(context, bannerListener);
            adView.fetchAd(renderingBundle);
            AdRegistration.removeAdMobCache((String)requestId);
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Success, metricsBuilder, correlationId);
        } else {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
            listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in renderAPSBannerAds", "com.amazon.device.ads"));
        }
    }

    void loadInterstitialAd(final Context context, final CustomEventInterstitialListener listener, Bundle customEventExtras, final String serverParameter, final DTBAdInterstitialListener dtbAdInterstitialListener, final ApsMetricsPerfEventModelBuilder metricsBuilder, final String correlationId) {
        String slotUUID = customEventExtras.getString("amazon_custom_event_slot_uuid");
        final String requestId = customEventExtras.getString("amazon_custom_event_request_id");
        if (DtbCommonUtils.isNullOrEmpty((String)customEventExtras.getString("amazon_custom_event_request_id"))) {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
            ApsLog.e((String)LOGTAG, (String)"Fail to load custom interstitial ad in loadInterstitialAd because no request id ");
            listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in loadInterstitialAd because previous bid requests failure", "com.amazon.device.ads"));
            return;
        }
        if (!DtbCommonUtils.isNullOrEmpty((String)slotUUID)) {
            DTBAdRequest dtbAdRequest = APSAdMobAdapterUtil.createDtbAdRequest(customEventExtras);
            dtbAdRequest.setCorrelationId(correlationId);
            dtbAdRequest.setSizes(new DTBAdSize[]{new DTBAdSize.DTBInterstitialAdSize(slotUUID)});
            final DTBCacheData dtbCacheData = new DTBCacheData(requestId, dtbAdRequest);
            AdRegistration.addAdMobCache((String)requestId, (DTBCacheData)dtbCacheData);
            dtbAdRequest.loadAd(new DTBAdCallback(){

                public void onFailure(@NonNull com.amazon.device.ads.AdError adError) {
                    ApsLog.e((String)LOGTAG, (String)("Failed to load the ad; " + adError.getMessage()));
                    dtbCacheData.setBidRequestFailed(true);
                    ApsMetrics.Companion.adapterEvent(null, metricsBuilder);
                    listener.onAdFailedToLoad(new AdError(3, "Fail to load custom interstitial ad in loadInterstitialAd", "com.amazon.device.ads"));
                }

                public void onSuccess(@NonNull DTBAdResponse dtbAdResponse) {
                    Log.i((String)LOGTAG, (String)" Load the ad successfully");
                    dtbCacheData.addResponse(dtbAdResponse);
                    metricsBuilder.withBidId(dtbAdResponse.getBidId());
                    ApsMetrics.Companion.adapterEvent(dtbAdResponse.getBidId(), metricsBuilder);
                    Bundle renderingBundle = dtbAdResponse.getRenderingBundle();
                    APSAdMobUtil.this.renderAPSInterstitialAds(context, listener, serverParameter, renderingBundle, requestId, dtbAdInterstitialListener, metricsBuilder, correlationId);
                }
            });
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Success, metricsBuilder, correlationId);
        } else {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
            ApsLog.e((String)LOGTAG, (String)"Fail to execute loadInterstitialAd method because not have sufficient info");
            listener.onAdFailedToLoad(new AdError(3, "Fail to load custom interstitial ad in loadInterstitialAd", "com.amazon.device.ads"));
        }
    }

    void renderAPSInterstitialAds(Context context, CustomEventInterstitialListener listener, String serverParameter, Bundle renderingBundle, String requestId, DTBAdInterstitialListener dtbAdInterstitialListener, ApsMetricsPerfEventModelBuilder metricsBuilder, String correlationId) {
        if (DTBAdUtil.validateSinglePriceAdMobCustomEvent((String)serverParameter, (Bundle)renderingBundle)) {
            this.interstitial = new DTBAdInterstitial(context, dtbAdInterstitialListener);
            this.interstitial.fetchAd(renderingBundle);
            AdRegistration.removeAdMobCache((String)requestId);
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Success, metricsBuilder, correlationId);
        } else {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
            listener.onAdFailedToLoad(new AdError(3, "Fail to load custom interstitial ad in renderAPSInterstitialAds method", "com.amazon.device.ads"));
        }
    }

    DTBAdInterstitial getInterstitial() {
        return this.interstitial;
    }
}

