/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.admob_adapter;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.amazon.admob_adapter.APSAdMobAdapterUtil;
import com.amazon.admob_adapter.APSAdMobUtil;
import com.amazon.admob_adapter.CustomEventListenerAdapter;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsResult;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdInterstitialListener;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBCacheData;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.rewarded.RewardItem;

class APSAdMobRewardedCustomEventLoader
implements MediationRewardedAd,
DTBAdInterstitialListener {
    private static final String LOGTAG = APSAdMobRewardedCustomEventLoader.class.getSimpleName();
    private APSAdMobUtil apsAdMobUtil;
    private final MediationRewardedAdConfiguration mediationRewardedAdConfiguration;
    private final MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback;
    private MediationRewardedAdCallback mediationRewardedAdCallback;

    APSAdMobRewardedCustomEventLoader(MediationRewardedAdConfiguration mediationRewardedAdConfiguration, MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback) {
        this.mediationRewardedAdConfiguration = mediationRewardedAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
        this.apsAdMobUtil = new APSAdMobUtil();
    }

    void loadAd(ApsMetricsPerfEventModelBuilder metricsBuilder, String correlationId) {
        try {
            CustomEventListenerAdapter customEventListenerAdapter = new CustomEventListenerAdapter(this.mediationAdLoadCallback);
            Bundle customEventExtras = this.mediationRewardedAdConfiguration.getMediationExtras();
            Context context = this.mediationRewardedAdConfiguration.getContext();
            String serverParameter = this.mediationRewardedAdConfiguration.getServerParameters().getString("parameter");
            if (customEventExtras.containsKey("amazon_custom_event_adapter_version") && customEventExtras.getString("amazon_custom_event_adapter_version", "1.0").equals("2.0")) {
                String requestId = customEventExtras.getString("amazon_custom_event_request_id");
                DTBCacheData dtbCacheData = AdRegistration.getAdMobCache((String)requestId);
                if (dtbCacheData != null) {
                    if (dtbCacheData.isBidRequestFailed()) {
                        ApsLog.e((String)LOGTAG, (String)"Fail to load custom interstitial ad in loadAd because previous bid requests failure");
                        APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
                        this.mediationAdLoadCallback.onFailure(new AdError(3, "Fail to load custom banner ad in loadAd because previous bid requests failure", "com.amazon.device.ads"));
                        return;
                    }
                    DTBAdResponse currentAdResponse = dtbCacheData.getAdResponse();
                    if (currentAdResponse != null) {
                        Bundle renderingBundle = currentAdResponse.getRenderingBundle();
                        this.apsAdMobUtil.renderAPSInterstitialAds(context, customEventListenerAdapter, serverParameter, renderingBundle, requestId, this, metricsBuilder, correlationId);
                        return;
                    }
                }
                this.apsAdMobUtil.loadInterstitialAd(context, customEventListenerAdapter, customEventExtras, serverParameter, this, metricsBuilder, correlationId);
            } else {
                APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
                Log.d((String)LOGTAG, (String)"Please upgrade to APS API since we don't support Rewarded video through DTB API!");
                this.mediationAdLoadCallback.onFailure(new AdError(3, "Please upgrade to APS API since we don't support Rewarded video through DTB API!", "com.amazon.device.ads"));
            }
        }
        catch (RuntimeException e) {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute loadAd method during runtime in APSAdMobRewardedCustomEventLoader class", (Exception)e);
            this.mediationAdLoadCallback.onFailure(new AdError(3, "Fail to load custom interstitial ad in loadAd method", "com.amazon.device.ads"));
        }
    }

    public void onAdLoaded(View view) {
        try {
            if (this.mediationAdLoadCallback != null) {
                this.mediationRewardedAdCallback = (MediationRewardedAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdLoaded method during runtime in APSAdMobRewardedCustomEventLoader class", (Exception)e);
        }
    }

    public void onAdFailed(View view) {
        AdError adError = new AdError(3, "Custom interstitial ad failed to load", "com.amazon.device.ads");
        try {
            if (this.mediationAdLoadCallback != null) {
                this.mediationAdLoadCallback.onFailure(adError);
            }
            this.mediationRewardedAdCallback.onAdFailedToShow(adError);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdFailedToShow method during runtime in APSAdMobRewardedCustomEventLoader class", (Exception)e);
        }
    }

    public void onAdClicked(View view) {
        try {
            if (this.mediationRewardedAdCallback != null) {
                this.mediationRewardedAdCallback.reportAdClicked();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute reportAdClicked method during runtime in APSAdMobRewardedCustomEventLoader class", (Exception)e);
        }
    }

    public void onAdLeftApplication(View view) {
    }

    public void onAdOpen(View view) {
        try {
            if (this.mediationRewardedAdCallback != null) {
                this.mediationRewardedAdCallback.onAdOpened();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdOpen method during runtime in APSAdMobRewardedCustomEventLoader class", (Exception)e);
        }
    }

    public void onAdClosed(View view) {
        try {
            if (this.mediationRewardedAdCallback != null) {
                this.mediationRewardedAdCallback.onAdClosed();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdClosed method during runtime in APSAdMobRewardedCustomEventLoader class", (Exception)e);
        }
    }

    public void onImpressionFired(View view) {
    }

    public void showAd(@NonNull Context context) {
        try {
            if (this.apsAdMobUtil.getInterstitial() != null) {
                this.apsAdMobUtil.getInterstitial().show();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute show Ad method during runtime in APSAdMobRewardedCustomEventLoader class", (Exception)e);
            this.mediationAdLoadCallback.onFailure(new AdError(3, "Fail to show custom interstitial ad in APSAdMobRewardedCustomEventLoader class", "com.amazon.device.ads"));
        }
    }

    public void onVideoCompleted(View view) {
        try {
            super.onVideoCompleted(view);
            APSReward reward = new APSReward();
            if (this.mediationRewardedAdCallback != null) {
                APSAdMobAdapterUtil.executeOnMainThread(() -> {
                    this.mediationRewardedAdCallback.onVideoComplete();
                    this.mediationRewardedAdCallback.onUserEarnedReward((RewardItem)reward);
                });
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onVideoComplete method during runtime in APSAdMobRewardedCustomEventLoader class", (Exception)e);
        }
    }

    static class APSReward
    implements RewardItem {
        APSReward() {
        }

        @NonNull
        public String getType() {
            return "";
        }

        public int getAmount() {
            return 1;
        }
    }
}

