/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.admob_adapter;

import android.content.Context;
import androidx.annotation.NonNull;
import com.amazon.admob_adapter.APSAdMobAdapter;
import com.amazon.admob_adapter.APSAdMobAdapterUtil;
import com.amazon.admob_adapter.APSAdMobBannerCustomEventLoader;
import com.amazon.admob_adapter.APSAdMobInterstitialCustomEventLoader;
import com.amazon.admob_adapter.APSAdMobRewardedCustomEventLoader;
import com.amazon.admob_adapter.APSAdMobUtil;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsResult;
import com.amazon.device.ads.AdRegistration;
import com.google.android.gms.ads.mediation.Adapter;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.VersionInfo;
import java.util.List;
import java.util.UUID;

public class APSAdMobCustomEvent
extends Adapter {
    private APSAdMobBannerCustomEventLoader bannerLoader;
    private APSAdMobInterstitialCustomEventLoader interstitialLoader;
    private APSAdMobRewardedCustomEventLoader rewardedLoader;
    private String correlationId = null;
    private final ApsMetricsPerfEventModelBuilder metricsBuilder = new ApsMetricsPerfEventModelBuilder();

    @NonNull
    public VersionInfo getSDKVersionInfo() {
        try {
            String sdkVersion = AdRegistration.getVersion();
            String[] splits = sdkVersion.split("-");
            return this.getVersionInfoFromString(splits[2]);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute getSDKVersionInfo method during runtime in APSAdMobCustomEvent class", (Exception)e);
            return new VersionInfo(0, 0, 0);
        }
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        try {
            String versionString = APSAdMobAdapter.getVersion();
            return this.getVersionInfoFromString(versionString);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute getVersionInfo method during runtime in APSAdMobCustomEvent class", (Exception)e);
            return new VersionInfo(0, 0, 0);
        }
    }

    public void initialize(@NonNull Context context, @NonNull InitializationCompleteCallback initializationCompleteCallback, @NonNull List<MediationConfiguration> list) {
        try {
            initializationCompleteCallback.onInitializationSucceeded();
            APSAdMobAdapterUtil.setupMetricsAndRemoteLogs();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute initialize method during runtime in APSAdMobCustomEvent class", (Exception)e);
        }
    }

    public void loadBannerAd(@NonNull MediationBannerAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        try {
            this.metricsBuilder.withAdapterStartTime(System.currentTimeMillis());
            this.correlationId = UUID.randomUUID().toString();
            this.bannerLoader = new APSAdMobBannerCustomEventLoader(adConfiguration, callback);
            this.bannerLoader.loadAd(this.metricsBuilder, this.correlationId);
        }
        catch (RuntimeException e) {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute loadBannerAd method during runtime in APSAdMobCustomEvent class", (Exception)e);
        }
    }

    public void loadInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        try {
            this.metricsBuilder.withAdapterStartTime(System.currentTimeMillis());
            this.correlationId = UUID.randomUUID().toString();
            this.interstitialLoader = new APSAdMobInterstitialCustomEventLoader(adConfiguration, callback);
            this.interstitialLoader.loadAd(this.metricsBuilder, this.correlationId);
        }
        catch (RuntimeException e) {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute loadInterstitialAd method during runtime in APSAdMobCustomEvent class", (Exception)e);
        }
    }

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback) {
        try {
            this.metricsBuilder.withAdapterStartTime(System.currentTimeMillis());
            this.correlationId = UUID.randomUUID().toString();
            this.rewardedLoader = new APSAdMobRewardedCustomEventLoader(mediationRewardedAdConfiguration, mediationAdLoadCallback);
            this.rewardedLoader.loadAd(this.metricsBuilder, this.correlationId);
        }
        catch (RuntimeException e) {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute loadRewardedAd method during runtime in APSAdMobCustomEvent class", (Exception)e);
        }
    }

    private VersionInfo getVersionInfoFromString(String versionString) {
        String[] splits = versionString.split("\\.");
        if (splits.length >= 3) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]);
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected version format: %s. Returning 0.0.0 for version.", versionString);
        ApsLog.e((String)"APSAnalytics", (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }
}

