/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.admob_adapter;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.amazon.admob_adapter.APSAdMobAdapter;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DtbCommonUtils;

public class APSAdMobAdapterUtil {
    private static final String LOG_TAG = APSAdMobAdapterUtil.class.getSimpleName();

    private APSAdMobAdapterUtil() {
    }

    static void setupMetricsAndRemoteLogs() {
        String adapterVersion = "admob-" + APSAdMobAdapter.getVersion();
        APSAnalytics.setAdapterVersion((String)adapterVersion);
        ApsMetrics.Companion.setAdapterVersion(adapterVersion);
    }

    static DTBAdRequest createDtbAdRequest(@NonNull Bundle customEventExtras) {
        DTBAdRequest dtbAdRequest = new DTBAdRequest();
        try {
            if (!customEventExtras.isEmpty()) {
                if (customEventExtras.containsKey("aps_privacy") && !DtbCommonUtils.isNullOrEmpty((String)customEventExtras.getString("aps_privacy"))) {
                    dtbAdRequest.putCustomTarget("aps_privacy", customEventExtras.getString("aps_privacy"));
                }
                if (customEventExtras.containsKey("us_privacy") && !DtbCommonUtils.isNullOrEmpty((String)customEventExtras.getString("us_privacy"))) {
                    dtbAdRequest.putCustomTarget("us_privacy", customEventExtras.getString("us_privacy"));
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Failed to get CCPA consent from customEventExtras", (Exception)e);
        }
        return dtbAdRequest;
    }

    static void executeOnMainThread(Runnable proc) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(proc);
    }
}

