/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.servlet.verifiers;

import com.amazon.ask.model.Request;
import com.amazon.ask.servlet.ServletConstants;
import com.amazon.ask.servlet.verifiers.AlexaHttpRequest;
import com.amazon.ask.servlet.verifiers.SkillServletVerifier;
import com.amazon.ask.util.ValidationUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillRequestTimestampVerifier
implements SkillServletVerifier {
    private final long toleranceInMilliseconds;
    private static final Logger LOGGER = LoggerFactory.getLogger(SkillRequestTimestampVerifier.class);

    public SkillRequestTimestampVerifier(long toleranceInMilliseconds) {
        if (toleranceInMilliseconds > 150000L) {
            LOGGER.warn(String.format("Provided tolerance value %s exceeds the maximum allowed %s. Maximum value will be used instead.", toleranceInMilliseconds, 150000L));
            this.toleranceInMilliseconds = 150000L;
        } else {
            if (toleranceInMilliseconds < 0L) {
                throw new IllegalArgumentException("A negative tolerance is not supported");
            }
            this.toleranceInMilliseconds = toleranceInMilliseconds;
        }
    }

    public SkillRequestTimestampVerifier(long tolerance, TimeUnit timeUnit) {
        this(((TimeUnit)((Object)ValidationUtils.assertNotNull((Object)((Object)timeUnit), (String)"timeUnit"))).toMillis(tolerance));
    }

    @Override
    public void verify(AlexaHttpRequest alexaHttpRequest) {
        boolean withinTolerance;
        if (alexaHttpRequest.getDeserializedRequestEnvelope() == null) {
            throw new SecurityException("Incoming request did not contain a request envelope");
        }
        Request request = alexaHttpRequest.getDeserializedRequestEnvelope().getRequest();
        if (request == null || request.getTimestamp() == null) {
            throw new SecurityException("Incoming request was null or did not contain a timestamp to evaluate");
        }
        long requestTimestamp = request.getTimestamp().toInstant().toEpochMilli();
        long delta = Math.abs(System.currentTimeMillis() - requestTimestamp);
        if (ServletConstants.SKILL_EVENT_REQUESTS.contains(request.getType())) {
            withinTolerance = delta <= 3600000L;
        } else {
            boolean bl = withinTolerance = delta <= this.toleranceInMilliseconds;
        }
        if (!withinTolerance) {
            throw new SecurityException(String.format("Request with id %s and timestamp %s failed timestamp validation with a delta of %s", request.getRequestId(), requestTimestamp, delta));
        }
    }
}

