/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.servlet.verifiers;

import com.amazon.ask.servlet.verifiers.AlexaHttpRequest;
import com.amazon.ask.servlet.verifiers.SkillServletVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public final class SkillRequestSignatureVerifier
implements SkillServletVerifier {
    private static final Map<String, X509Certificate> CERTIFICATE_CACHE = new ConcurrentHashMap<String, X509Certificate>();
    private static final Integer DOMAIN_NAME_SUBJECT_ALTERNATIVE_NAME_ENTRY = 2;
    private static final String VALID_SIGNING_CERT_CHAIN_PROTOCOL = "https";
    private static final String VALID_SIGNING_CERT_CHAIN_URL_HOST_NAME = "s3.amazonaws.com";
    private static final String VALID_SIGNING_CERT_CHAIN_URL_PATH_PREFIX = "/echo.api/";
    private static final int UNSPECIFIED_SIGNING_CERT_CHAIN_URL_PORT_VALUE = -1;
    private static final int CERT_RETRIEVAL_RETRY_COUNT = 5;
    private static final int DELAY_BETWEEN_RETRIES_MS = 500;
    private static final int HTTP_OK_RESPONSE_CODE = 200;
    private final Proxy proxy;

    public SkillRequestSignatureVerifier() {
        this.proxy = null;
    }

    public SkillRequestSignatureVerifier(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void verify(AlexaHttpRequest alexaHttpRequest) {
        String baseEncoded64Signature = alexaHttpRequest.getBaseEncoded64Signature();
        String signingCertificateChainUrl = alexaHttpRequest.getSigningCertificateChainUrl();
        if (baseEncoded64Signature == null || signingCertificateChainUrl == null) {
            throw new SecurityException("Missing signature/certificate for the provided skill request");
        }
        try {
            X509Certificate signingCertificate = CERTIFICATE_CACHE.get(signingCertificateChainUrl);
            if (signingCertificate != null && signingCertificate.getNotAfter().after(new Date())) {
                signingCertificate.checkValidity();
            } else {
                signingCertificate = this.retrieveAndVerifyCertificateChain(signingCertificateChainUrl);
                CERTIFICATE_CACHE.put(signingCertificateChainUrl, signingCertificate);
            }
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(signingCertificate.getPublicKey());
            signature.update(alexaHttpRequest.getSerializedRequestEnvelope());
            if (!signature.verify(Base64.decodeBase64((byte[])baseEncoded64Signature.getBytes("UTF-8")))) {
                throw new SecurityException("Failed to verify the signature/certificate for the provided skill request");
            }
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new SecurityException("Failed to verify the signature/certificate for the provided skill request", ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509Certificate retrieveAndVerifyCertificateChain(String signingCertificateChainUrl) throws CertificateException {
        int attempt = 0;
        while (attempt <= 5) {
            block16: {
                X509Certificate x509Certificate;
                InputStream in = null;
                try {
                    HttpURLConnection connection;
                    HttpURLConnection httpURLConnection = connection = this.proxy != null ? (HttpURLConnection)SkillRequestSignatureVerifier.getAndVerifySigningCertificateChainUrl(signingCertificateChainUrl).openConnection(this.proxy) : (HttpURLConnection)SkillRequestSignatureVerifier.getAndVerifySigningCertificateChainUrl(signingCertificateChainUrl).openConnection();
                    if (connection.getResponseCode() != 200) {
                        if (!this.waitForRetry(attempt)) throw new CertificateException("Got a non-200 status code when retrieving certificate at URL: " + signingCertificateChainUrl);
                        if (in != null) {
                            IOUtils.closeQuietly((InputStream)in);
                        }
                        break block16;
                    }
                    in = connection.getInputStream();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Collection<? extends Certificate> certificateChain = certificateFactory.generateCertificates(in);
                    X509Certificate signingCertificate = (X509Certificate)certificateChain.iterator().next();
                    signingCertificate.checkValidity();
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                    X509TrustManager x509TrustManager = null;
                    for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                        if (!(trustManager instanceof X509TrustManager)) continue;
                        x509TrustManager = (X509TrustManager)trustManager;
                    }
                    if (x509TrustManager == null) {
                        throw new IllegalStateException("No X509 TrustManager available. Unable to check certificate chain");
                    }
                    x509TrustManager.checkServerTrusted(certificateChain.toArray(new X509Certificate[certificateChain.size()]), "RSA");
                    if (!this.subjectAlernativeNameListContainsEchoSdkDomainName(signingCertificate.getSubjectAlternativeNames())) {
                        throw new CertificateException("The provided certificate is not valid for the ASK SDK");
                    }
                    x509Certificate = signingCertificate;
                    if (in == null) return x509Certificate;
                }
                catch (IOException e) {
                    if (!this.waitForRetry(attempt)) {
                        throw new CertificateException("Unable to retrieve certificate from URL: " + signingCertificateChainUrl, e);
                    }
                    break block16;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (Exception e2) {
                        throw new CertificateException("Unable to verify certificate at URL: " + signingCertificateChainUrl, e2);
                    }
                }
                finally {
                    if (in != null) {
                        IOUtils.closeQuietly(in);
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
                return x509Certificate;
            }
            ++attempt;
        }
        throw new RuntimeException("Unable to retrieve signing certificate due to an unhandled exception");
    }

    private boolean waitForRetry(int attempt) {
        if (attempt < 5) {
            try {
                Thread.sleep(500L);
                return true;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted while waiting for certificate retrieval retry attempt", ex);
            }
        }
        return false;
    }

    private boolean subjectAlernativeNameListContainsEchoSdkDomainName(Collection<List<?>> subjectAlternativeNameEntries) {
        for (List<?> entry : subjectAlternativeNameEntries) {
            if (!(entry.get(0) instanceof Integer) || !(entry.get(1) instanceof String) || !DOMAIN_NAME_SUBJECT_ALTERNATIVE_NAME_ENTRY.equals(entry.get(0)) || !"echo-api.amazon.com".equals(entry.get(1))) continue;
            return true;
        }
        return false;
    }

    static URL getAndVerifySigningCertificateChainUrl(String signingCertificateChainUrl) throws CertificateException {
        try {
            URL url = new URI(signingCertificateChainUrl).normalize().toURL();
            if (!VALID_SIGNING_CERT_CHAIN_URL_HOST_NAME.equalsIgnoreCase(url.getHost())) {
                throw new CertificateException(String.format("SigningCertificateChainUrl [%s] does not contain the required hostname of [%s]", signingCertificateChainUrl, VALID_SIGNING_CERT_CHAIN_URL_HOST_NAME));
            }
            String path = url.getPath();
            if (!path.startsWith(VALID_SIGNING_CERT_CHAIN_URL_PATH_PREFIX)) {
                throw new CertificateException(String.format("SigningCertificateChainUrl path [%s] is invalid. Expecting path to start with [%s]", signingCertificateChainUrl, VALID_SIGNING_CERT_CHAIN_URL_PATH_PREFIX));
            }
            String urlProtocol = url.getProtocol();
            if (!VALID_SIGNING_CERT_CHAIN_PROTOCOL.equalsIgnoreCase(urlProtocol)) {
                throw new CertificateException(String.format("SigningCertificateChainUrl [%s] contains an unsupported protocol [%s]", signingCertificateChainUrl, urlProtocol));
            }
            int urlPort = url.getPort();
            if (urlPort != -1 && urlPort != url.getDefaultPort()) {
                throw new CertificateException(String.format("SigningCertificateChainUrl [%s] contains an invalid port [%d]", signingCertificateChainUrl, urlPort));
            }
            return url;
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException ex) {
            throw new CertificateException(String.format("SigningCertificateChainUrl [%s] is malformed", signingCertificateChainUrl), ex);
        }
    }
}

