/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.impl;

import com.amazon.ask.AlexaSkill;
import com.amazon.ask.request.SkillRequest;
import com.amazon.ask.request.UnmarshalledRequest;
import com.amazon.ask.response.SkillResponse;
import com.amazon.ask.response.impl.BaseSkillResponse;
import com.amazon.ask.util.JsonMarshaller;
import com.amazon.ask.util.JsonUnmarshaller;
import com.amazon.ask.util.ValidationUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public abstract class AbstractSkill<Request, Response>
implements AlexaSkill<Request, Response> {
    protected final List<JsonUnmarshaller<Request>> unmarshallerChain;
    protected final JsonMarshaller<Response> marshaller;

    protected AbstractSkill(JsonUnmarshaller<Request> unmarshaller, JsonMarshaller<Response> marshaller) {
        this(Collections.singletonList(unmarshaller), marshaller);
    }

    protected AbstractSkill(List<JsonUnmarshaller<Request>> unmarshallerChain, JsonMarshaller<Response> marshaller) {
        this.unmarshallerChain = ValidationUtils.assertNotNull(unmarshallerChain, "unmarshallerChain");
        this.marshaller = ValidationUtils.assertNotNull(marshaller, "marshaller");
    }

    @Override
    public SkillResponse<Response> execute(SkillRequest request, Object context) {
        JsonUnmarshaller<Request> unmarshaller;
        Optional<Object> deserializedRequest = Optional.empty();
        Iterator<JsonUnmarshaller<Request>> iterator = this.unmarshallerChain.iterator();
        while (iterator.hasNext() && !(deserializedRequest = (unmarshaller = iterator.next()).unmarshall(request.getRawRequest())).isPresent()) {
        }
        if (!deserializedRequest.isPresent()) {
            return null;
        }
        Response response = this.invoke((UnmarshalledRequest)deserializedRequest.get(), context);
        if (response == null) {
            return null;
        }
        return new BaseSkillResponse<Response>(this.marshaller, response);
    }

    protected abstract Response invoke(UnmarshalledRequest<Request> var1, Object var2);
}

