/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request.handler.chain.impl;

import com.amazon.ask.request.exception.handler.GenericExceptionHandler;
import com.amazon.ask.request.handler.GenericRequestHandler;
import com.amazon.ask.request.handler.chain.GenericRequestHandlerChain;
import com.amazon.ask.request.interceptor.GenericRequestInterceptor;
import com.amazon.ask.request.interceptor.GenericResponseInterceptor;
import java.util.ArrayList;
import java.util.List;

public class BaseRequestHandlerChain<Input, Output>
implements GenericRequestHandlerChain<Input, Output> {
    protected final GenericRequestHandler<Input, Output> handler;
    protected final List<GenericRequestInterceptor<Input>> requestInterceptors;
    protected final List<GenericResponseInterceptor<Input, Output>> responseInterceptors;
    protected final List<GenericExceptionHandler<Input, Output>> exceptionHandlers;

    protected BaseRequestHandlerChain(GenericRequestHandler<Input, Output> handler, List<GenericRequestInterceptor<Input>> requestInterceptors, List<GenericResponseInterceptor<Input, Output>> responseInterceptors, List<GenericExceptionHandler<Input, Output>> exceptionHandlers) {
        this.handler = handler;
        this.requestInterceptors = requestInterceptors != null ? requestInterceptors : new ArrayList();
        this.responseInterceptors = responseInterceptors != null ? responseInterceptors : new ArrayList();
        this.exceptionHandlers = exceptionHandlers != null ? exceptionHandlers : new ArrayList();
    }

    @Override
    public GenericRequestHandler<Input, Output> getRequestHandler() {
        return this.handler;
    }

    @Override
    public List<GenericRequestInterceptor<Input>> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    @Override
    public List<GenericResponseInterceptor<Input, Output>> getResponseInterceptors() {
        return this.responseInterceptors;
    }

    @Override
    public List<GenericExceptionHandler<Input, Output>> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public static <Input, Output, Self extends Builder<Input, Output, Self>> Builder<Input, Output, Self> forTypes(Class<Input> input, Class<Output> output) {
        return new Builder();
    }

    public static <Input, Output> Builder<Input, Output, ?> builder() {
        return new Builder();
    }

    public static class Builder<Input, Output, Self extends Builder<Input, Output, Self>> {
        protected GenericRequestHandler<Input, Output> handler;
        protected List<GenericRequestInterceptor<Input>> requestInterceptors;
        protected List<GenericResponseInterceptor<Input, Output>> responseInterceptors;
        protected List<GenericExceptionHandler<Input, Output>> exceptionHandlers;

        public Self withRequestHandler(GenericRequestHandler<Input, Output> handler) {
            this.handler = handler;
            return (Self)this;
        }

        public Self addRequestInterceptor(GenericRequestInterceptor<Input> requestInterceptor) {
            if (this.requestInterceptors == null) {
                this.requestInterceptors = new ArrayList<GenericRequestInterceptor<Input>>();
            }
            this.requestInterceptors.add(requestInterceptor);
            return (Self)this;
        }

        public Self withRequestInterceptors(List<GenericRequestInterceptor<Input>> requestInterceptors) {
            this.requestInterceptors = requestInterceptors;
            return (Self)this;
        }

        public Self addResponseInterceptor(GenericResponseInterceptor<Input, Output> responseInterceptor) {
            if (this.responseInterceptors == null) {
                this.responseInterceptors = new ArrayList<GenericResponseInterceptor<Input, Output>>();
            }
            this.responseInterceptors.add(responseInterceptor);
            return (Self)this;
        }

        public Self withResponseInterceptor(List<GenericResponseInterceptor<Input, Output>> responseInterceptors) {
            this.responseInterceptors = responseInterceptors;
            return (Self)this;
        }

        public Self withExceptionHandlers(List<GenericExceptionHandler<Input, Output>> exceptionHandlers) {
            this.exceptionHandlers = exceptionHandlers;
            return (Self)this;
        }

        public Self addExceptionHandler(GenericExceptionHandler<Input, Output> exceptionHandler) {
            if (this.exceptionHandlers == null) {
                this.exceptionHandlers = new ArrayList<GenericExceptionHandler<Input, Output>>();
            }
            this.exceptionHandlers.add(exceptionHandler);
            return (Self)this;
        }

        public BaseRequestHandlerChain<Input, Output> build() {
            return new BaseRequestHandlerChain<Input, Output>(this.handler, this.requestInterceptors, this.responseInterceptors, this.exceptionHandlers);
        }
    }
}

