/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request.dispatcher.impl;

import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.exception.UnhandledSkillException;
import com.amazon.ask.request.dispatcher.GenericRequestDispatcher;
import com.amazon.ask.request.exception.handler.GenericExceptionHandler;
import com.amazon.ask.request.exception.mapper.GenericExceptionMapper;
import com.amazon.ask.request.handler.adapter.GenericHandlerAdapter;
import com.amazon.ask.request.handler.chain.GenericRequestHandlerChain;
import com.amazon.ask.request.interceptor.GenericRequestInterceptor;
import com.amazon.ask.request.interceptor.GenericResponseInterceptor;
import com.amazon.ask.request.mapper.GenericRequestMapper;
import com.amazon.ask.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRequestDispatcher<Input, Output>
implements GenericRequestDispatcher<Input, Output> {
    private static final Logger logger = LoggerFactory.getLogger(BaseRequestDispatcher.class);
    protected final Collection<GenericRequestMapper<Input, Output>> requestMappers;
    protected final GenericExceptionMapper<Input, Output> exceptionMapper;
    protected final Collection<GenericHandlerAdapter<Input, Output>> handlerAdapters;
    protected final Collection<GenericRequestInterceptor<Input>> requestInterceptors;
    protected final Collection<GenericResponseInterceptor<Input, Output>> responseInterceptors;

    protected BaseRequestDispatcher(Collection<GenericRequestMapper<Input, Output>> requestMappers, GenericExceptionMapper<Input, Output> exceptionMapper, Collection<GenericHandlerAdapter<Input, Output>> handlerAdapters, Collection<GenericRequestInterceptor<Input>> requestInterceptors, Collection<GenericResponseInterceptor<Input, Output>> responseInterceptors) {
        this.requestMappers = ValidationUtils.assertNotEmpty(requestMappers, "requestMappers");
        this.exceptionMapper = exceptionMapper;
        this.handlerAdapters = ValidationUtils.assertNotNull(handlerAdapters, "handlerAdapters");
        this.requestInterceptors = requestInterceptors != null ? requestInterceptors : new ArrayList();
        this.responseInterceptors = responseInterceptors != null ? responseInterceptors : new ArrayList();
    }

    @Override
    public Output dispatch(Input input) throws AskSdkException {
        try {
            return this.doDispatch(input);
        }
        catch (Exception e) {
            Optional exceptionHandler;
            Optional<Object> optional = exceptionHandler = this.exceptionMapper != null ? this.exceptionMapper.getHandler(input, e) : Optional.empty();
            if (exceptionHandler.isPresent()) {
                return ((GenericExceptionHandler)exceptionHandler.get()).handle(input, e);
            }
            throw new UnhandledSkillException(e);
        }
    }

    private Output doDispatch(Input input) throws Exception {
        Output response;
        GenericRequestMapper<Input, Output> mapper;
        for (GenericRequestInterceptor<Input> genericRequestInterceptor : this.requestInterceptors) {
            genericRequestInterceptor.process(input);
        }
        Optional<Object> handlerChain = Optional.empty();
        Iterator<GenericRequestMapper<Input, Output>> iterator = this.requestMappers.iterator();
        while (iterator.hasNext() && !(handlerChain = (mapper = iterator.next()).getRequestHandlerChain(input)).isPresent()) {
        }
        if (!handlerChain.isPresent()) {
            String string = "Unable to find a suitable request handler";
            logger.error(string);
            throw new AskSdkException(string);
        }
        logger.debug("Found matching handler");
        Object object = ((GenericRequestHandlerChain)handlerChain.get()).getRequestHandler();
        GenericHandlerAdapter<Input, Output> handlerAdapter = null;
        for (GenericHandlerAdapter<Input, Output> genericHandlerAdapter : this.handlerAdapters) {
            if (!genericHandlerAdapter.supports(object)) continue;
            handlerAdapter = genericHandlerAdapter;
            logger.debug("Found compatible adapter {}", (Object)genericHandlerAdapter.getClass().getName());
            break;
        }
        if (handlerAdapter == null) {
            String message = "Unable to find a suitable handler adapter";
            logger.error(message);
            throw new AskSdkException(message);
        }
        try {
            for (GenericRequestInterceptor<Input> genericRequestInterceptor : ((GenericRequestHandlerChain)handlerChain.get()).getRequestInterceptors()) {
                genericRequestInterceptor.process(input);
            }
            response = handlerAdapter.execute(input, object);
            for (GenericResponseInterceptor<Input, Output> genericResponseInterceptor : ((GenericRequestHandlerChain)handlerChain.get()).getResponseInterceptors()) {
                response = genericResponseInterceptor.processResponse(input, response);
            }
        }
        catch (Exception exception) {
            return ((GenericRequestHandlerChain)handlerChain.get()).getExceptionHandlers().stream().filter(exceptionHandler -> exceptionHandler.canHandle(input, e)).findFirst().orElseThrow(() -> e).handle(input, exception);
        }
        for (GenericResponseInterceptor<Input, Output> genericResponseInterceptor : this.responseInterceptors) {
            response = genericResponseInterceptor.processResponse(input, response);
        }
        return response;
    }

    public static <Input, Output, Self extends Builder<Input, Output, Self>> Builder<Input, Output, Self> forTypes(Class<Input> input, Class<Output> output) {
        return new Builder();
    }

    public static <Input, Output> Builder<Input, Output, ?> builder() {
        return new Builder();
    }

    public static class Builder<Input, Output, Self extends Builder<Input, Output, Self>> {
        protected Collection<GenericRequestMapper<Input, Output>> requestMappers;
        protected GenericExceptionMapper<Input, Output> exceptionMapper;
        protected Collection<GenericHandlerAdapter<Input, Output>> handlerAdapters;
        protected Collection<GenericRequestInterceptor<Input>> requestInterceptors;
        protected Collection<GenericResponseInterceptor<Input, Output>> responseInterceptors;

        protected Builder() {
        }

        public Self withRequestMappers(Collection<GenericRequestMapper<Input, Output>> requestMappers) {
            this.requestMappers = requestMappers;
            return (Self)this;
        }

        public Self withRequestMappers(GenericRequestMapper<Input, Output> ... requestMappers) {
            this.requestMappers = Arrays.asList(requestMappers);
            return (Self)this;
        }

        public Self addRequestMapper(GenericRequestMapper<Input, Output> requestMapper) {
            if (this.requestMappers == null) {
                this.requestMappers = new ArrayList<GenericRequestMapper<Input, Output>>();
            }
            this.requestMappers.add(requestMapper);
            return (Self)this;
        }

        public Self withExceptionMapper(GenericExceptionMapper<Input, Output> exceptionMapper) {
            this.exceptionMapper = exceptionMapper;
            return (Self)this;
        }

        public Self withHandlerAdapters(Collection<GenericHandlerAdapter<Input, Output>> adapters) {
            this.handlerAdapters = adapters;
            return (Self)this;
        }

        public Self withHandlerAdapters(GenericHandlerAdapter<Input, Output> ... adapters) {
            this.handlerAdapters = Arrays.asList(adapters);
            return (Self)this;
        }

        public Self addHandlerAdapter(GenericHandlerAdapter<Input, Output> adapter) {
            if (this.handlerAdapters == null) {
                this.handlerAdapters = new ArrayList<GenericHandlerAdapter<Input, Output>>();
            }
            this.handlerAdapters.add(adapter);
            return (Self)this;
        }

        public Self withRequestInterceptors(Collection<GenericRequestInterceptor<Input>> requestInterceptors) {
            this.requestInterceptors = requestInterceptors;
            return (Self)this;
        }

        public Self withRequestInterceptors(GenericRequestInterceptor<Input> ... requestInterceptors) {
            this.requestInterceptors = Arrays.asList(requestInterceptors);
            return (Self)this;
        }

        public Self addRequestInterceptor(GenericRequestInterceptor<Input> requestInterceptor) {
            if (this.requestInterceptors == null) {
                this.requestInterceptors = new ArrayList<GenericRequestInterceptor<Input>>();
            }
            this.requestInterceptors.add(requestInterceptor);
            return (Self)this;
        }

        public Self withResponseInterceptors(Collection<GenericResponseInterceptor<Input, Output>> responseInterceptors) {
            this.responseInterceptors = responseInterceptors;
            return (Self)this;
        }

        public Self withResponseInterceptors(GenericResponseInterceptor<Input, Output> ... responseInterceptors) {
            this.responseInterceptors = Arrays.asList(responseInterceptors);
            return (Self)this;
        }

        public Self addResponseInterceptor(GenericResponseInterceptor<Input, Output> responseInterceptor) {
            if (this.responseInterceptors == null) {
                this.responseInterceptors = new ArrayList<GenericResponseInterceptor<Input, Output>>();
            }
            this.responseInterceptors.add(responseInterceptor);
            return (Self)this;
        }

        public GenericRequestDispatcher<Input, Output> build() {
            return new BaseRequestDispatcher<Input, Output>(this.requestMappers, this.exceptionMapper, this.handlerAdapters, this.requestInterceptors, this.responseInterceptors);
        }
    }
}

