/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.timerManagement;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.timerManagement.Error;
import com.amazon.ask.model.services.timerManagement.TimerManagementService;
import com.amazon.ask.model.services.timerManagement.TimerRequest;
import com.amazon.ask.model.services.timerManagement.TimerResponse;
import com.amazon.ask.model.services.timerManagement.TimersResponse;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class TimerManagementServiceClient
extends BaseServiceClient
implements TimerManagementService {
    private final UserAgentHelper userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.40.0").build();

    public TimerManagementServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public ApiResponse<Void> callDeleteTimers() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/timers";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Unauthorized"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("DELETE", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null, false);
    }

    @Override
    public void deleteTimers() throws ServiceException {
        this.callDeleteTimers().getResponse();
    }

    @Override
    public ApiResponse<TimersResponse> callGetTimers() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/timers";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(TimersResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Unauthorized"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, TimersResponse.class, false);
    }

    @Override
    public TimersResponse getTimers() throws ServiceException {
        return (TimersResponse)this.callGetTimers().getResponse();
    }

    @Override
    public ApiResponse<Void> callDeleteTimer(String id) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", id);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/timers/{id}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Unauthorized"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Timer not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("DELETE", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null, false);
    }

    @Override
    public void deleteTimer(String id) throws ServiceException {
        this.callDeleteTimer(id).getResponse();
    }

    @Override
    public ApiResponse<TimerResponse> callGetTimer(String id) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", id);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/timers/{id}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(TimerResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Unauthorized"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Timer not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, TimerResponse.class, false);
    }

    @Override
    public TimerResponse getTimer(String id) throws ServiceException {
        return (TimerResponse)this.callGetTimer(id).getResponse();
    }

    @Override
    public ApiResponse<Void> callPauseTimer(String id) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", id);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/timers/{id}/pause";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Unauthorized"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Timer not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 504, "Device offline"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null, false);
    }

    @Override
    public void pauseTimer(String id) throws ServiceException {
        this.callPauseTimer(id).getResponse();
    }

    @Override
    public ApiResponse<Void> callResumeTimer(String id) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", id);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/timers/{id}/resume";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Unauthorized"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Timer not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 504, "Device offline"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null, false);
    }

    @Override
    public void resumeTimer(String id) throws ServiceException {
        this.callResumeTimer(id).getResponse();
    }

    @Override
    public ApiResponse<TimerResponse> callCreateTimer(TimerRequest timerRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/timers";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(TimerResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Unauthorized"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 504, "Device offline"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, timerRequest, TimerResponse.class, false);
    }

    @Override
    public TimerResponse createTimer(TimerRequest timerRequest) throws ServiceException {
        return (TimerResponse)this.callCreateTimer(timerRequest).getResponse();
    }
}

