/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.skillMessaging;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.AuthenticationConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.DefaultApiConfiguration;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.lwa.LwaClient;
import com.amazon.ask.model.services.lwa.model.GrantType;
import com.amazon.ask.model.services.skillMessaging.Error;
import com.amazon.ask.model.services.skillMessaging.SendSkillMessagingRequest;
import com.amazon.ask.model.services.skillMessaging.SkillMessagingService;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class SkillMessagingServiceClient
extends BaseServiceClient
implements SkillMessagingService {
    private final UserAgentHelper userAgentHelper;
    private final LwaClient lwaClient;

    public SkillMessagingServiceClient(ApiConfiguration apiConfiguration, AuthenticationConfiguration authenticationConfiguration) {
        super(apiConfiguration);
        this.lwaClient = LwaClient.builder().withAuthenticationConfiguration(authenticationConfiguration).withGrantType(GrantType.CLIENT_CREDENTIALS).withApiConfiguration((ApiConfiguration)DefaultApiConfiguration.builder().withApiClient(apiConfiguration.getApiClient()).withSerializer(apiConfiguration.getSerializer()).build()).build();
        this.userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.40.0").build();
    }

    public SkillMessagingServiceClient(ApiConfiguration apiConfiguration, LwaClient lwaClient) {
        super(apiConfiguration);
        this.lwaClient = lwaClient;
        this.userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.40.0").build();
    }

    @Override
    public ApiResponse<Void> callSendSkillMessage(String userId, SendSkillMessagingRequest sendSkillMessagingRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("userId", userId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String accessToken = this.lwaClient.getAccessTokenForScope("alexa:skill_messaging");
        headerParams.add(new Pair((Object)"Authorization", (Object)("Bearer " + accessToken)));
        String resourcePath = "/v1/skillmessages/users/{userId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 202, "Message has been successfully accepted, and will be sent to the skill "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Data is missing or not valid "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The skill messaging authentication token is expired or not valid "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "The passed userId does not exist "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The requester has exceeded their maximum allowable rate of messages "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "The SkillMessaging service encountered an internal error for a valid request. "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Unexpected error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, sendSkillMessagingRequest, null, false);
    }

    @Override
    public void sendSkillMessage(String userId, SendSkillMessagingRequest sendSkillMessagingRequest) throws ServiceException {
        this.callSendSkillMessage(userId, sendSkillMessagingRequest).getResponse();
    }
}

