/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.reminderManagement.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Event {
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="alertToken")
    private String alertToken = null;

    private Event() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Event(Builder builder) {
        if (builder.status != null) {
            this.status = builder.status;
        }
        if (builder.alertToken != null) {
            this.alertToken = builder.alertToken;
        }
    }

    public Status getStatus() {
        return Status.fromValue(this.status);
    }

    @JsonProperty(value="status")
    public String getStatusAsString() {
        return this.status;
    }

    @JsonProperty(value="alertToken")
    public String getAlertToken() {
        return this.alertToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event servicesReminderManagementEvent = (Event)o;
        return Objects.equals(this.status, servicesReminderManagementEvent.status) && Objects.equals(this.alertToken, servicesReminderManagementEvent.alertToken);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.alertToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    alertToken: ").append(this.toIndentedString(this.alertToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String status;
        private String alertToken;

        private Builder() {
        }

        @JsonProperty(value="status")
        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status != null ? status.toString() : null;
            return this;
        }

        @JsonProperty(value="alertToken")
        public Builder withAlertToken(String alertToken) {
            this.alertToken = alertToken;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

