/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.monetization;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.monetization.Error;
import com.amazon.ask.model.services.monetization.InSkillProduct;
import com.amazon.ask.model.services.monetization.InSkillProductTransactionsResponse;
import com.amazon.ask.model.services.monetization.InSkillProductsResponse;
import com.amazon.ask.model.services.monetization.MonetizationService;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;

public class MonetizationServiceClient
extends BaseServiceClient
implements MonetizationService {
    private final UserAgentHelper userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.40.0").build();

    public MonetizationServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public ApiResponse<InSkillProductsResponse> callGetInSkillProducts(String acceptLanguage, String purchasable, String entitled, String productType, String nextToken, BigDecimal maxResults) throws ServiceException {
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        if (purchasable != null) {
            queryParams.add(new Pair((Object)"purchasable", (Object)purchasable));
        }
        if (entitled != null) {
            queryParams.add(new Pair((Object)"entitled", (Object)entitled));
        }
        if (productType != null) {
            queryParams.add(new Pair((Object)"productType", (Object)productType));
        }
        if (nextToken != null) {
            queryParams.add(new Pair((Object)"nextToken", (Object)nextToken));
        }
        if (maxResults != null) {
            queryParams.add(new Pair((Object)"maxResults", (Object)maxResults.toString()));
        }
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        if (acceptLanguage != null) {
            headerParams.add(new Pair((Object)"Accept-Language", (Object)acceptLanguage));
        }
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/users/~current/skills/~current/inSkillProducts";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(InSkillProductsResponse.class, 200, "Returns a list of In-Skill products on success."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Invalid request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is invalid or doesn't have access to make this request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, InSkillProductsResponse.class, false);
    }

    @Override
    public InSkillProductsResponse getInSkillProducts(String acceptLanguage, String purchasable, String entitled, String productType, String nextToken, BigDecimal maxResults) throws ServiceException {
        return (InSkillProductsResponse)this.callGetInSkillProducts(acceptLanguage, purchasable, entitled, productType, nextToken, maxResults).getResponse();
    }

    @Override
    public ApiResponse<InSkillProduct> callGetInSkillProduct(String acceptLanguage, String productId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("productId", productId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        if (acceptLanguage != null) {
            headerParams.add(new Pair((Object)"Accept-Language", (Object)acceptLanguage));
        }
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/users/~current/skills/~current/inSkillProducts/{productId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(InSkillProduct.class, 200, "Returns an In-Skill Product on success."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Invalid request."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is invalid or doesn't have access to make this request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Requested resource not found."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, InSkillProduct.class, false);
    }

    @Override
    public InSkillProduct getInSkillProduct(String acceptLanguage, String productId) throws ServiceException {
        return (InSkillProduct)this.callGetInSkillProduct(acceptLanguage, productId).getResponse();
    }

    @Override
    public ApiResponse<InSkillProductTransactionsResponse> callGetInSkillProductsTransactions(String acceptLanguage, String productId, String status, OffsetDateTime fromLastModifiedTime, OffsetDateTime toLastModifiedTime, String nextToken, BigDecimal maxResults) throws ServiceException {
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        if (productId != null) {
            queryParams.add(new Pair((Object)"productId", (Object)productId));
        }
        if (status != null) {
            queryParams.add(new Pair((Object)"status", (Object)status));
        }
        if (fromLastModifiedTime != null) {
            queryParams.add(new Pair((Object)"fromLastModifiedTime", (Object)fromLastModifiedTime.toString()));
        }
        if (toLastModifiedTime != null) {
            queryParams.add(new Pair((Object)"toLastModifiedTime", (Object)toLastModifiedTime.toString()));
        }
        if (nextToken != null) {
            queryParams.add(new Pair((Object)"nextToken", (Object)nextToken));
        }
        if (maxResults != null) {
            queryParams.add(new Pair((Object)"maxResults", (Object)maxResults.toString()));
        }
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        if (acceptLanguage != null) {
            headerParams.add(new Pair((Object)"Accept-Language", (Object)acceptLanguage));
        }
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/users/~current/skills/~current/inSkillProductsTransactions";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(InSkillProductTransactionsResponse.class, 200, "Returns a list of transactions of all in skill products purchases in last 30 days on success."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Invalid request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is invalid or doesn't have access to make this request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Product id doesn't exist / invalid / not found."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 412, "Non-Child Directed Skill is not supported."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The request is throttled."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, InSkillProductTransactionsResponse.class, false);
    }

    @Override
    public InSkillProductTransactionsResponse getInSkillProductsTransactions(String acceptLanguage, String productId, String status, OffsetDateTime fromLastModifiedTime, OffsetDateTime toLastModifiedTime, String nextToken, BigDecimal maxResults) throws ServiceException {
        return (InSkillProductTransactionsResponse)this.callGetInSkillProductsTransactions(acceptLanguage, productId, status, fromLastModifiedTime, toLastModifiedTime, nextToken, maxResults).getResponse();
    }

    @Override
    public ApiResponse<Boolean> callGetVoicePurchaseSetting() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/users/~current/skills/~current/settings/voicePurchasing.enabled";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(Boolean.class, 200, "Returns a boolean value for voice purchase setting on success."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Invalid request."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is invalid or doesn't have access to make this request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, Boolean.class, false);
    }

    @Override
    public Boolean getVoicePurchaseSetting() throws ServiceException {
        return (Boolean)this.callGetVoicePurchaseSetting().getResponse();
    }
}

