/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.monetization;

import com.amazon.ask.model.services.monetization.EntitledState;
import com.amazon.ask.model.services.monetization.EntitlementReason;
import com.amazon.ask.model.services.monetization.ProductType;
import com.amazon.ask.model.services.monetization.PurchasableState;
import com.amazon.ask.model.services.monetization.PurchaseMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class InSkillProduct {
    @JsonProperty(value="productId")
    private String productId = null;
    @JsonProperty(value="referenceName")
    private String referenceName = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="summary")
    private String summary = null;
    @JsonProperty(value="purchasable")
    private String purchasable = null;
    @JsonProperty(value="entitled")
    private String entitled = null;
    @JsonProperty(value="entitlementReason")
    private String entitlementReason = null;
    @JsonProperty(value="activeEntitlementCount")
    private Integer activeEntitlementCount = null;
    @JsonProperty(value="purchaseMode")
    private String purchaseMode = null;

    private InSkillProduct() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private InSkillProduct(Builder builder) {
        if (builder.productId != null) {
            this.productId = builder.productId;
        }
        if (builder.referenceName != null) {
            this.referenceName = builder.referenceName;
        }
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.summary != null) {
            this.summary = builder.summary;
        }
        if (builder.purchasable != null) {
            this.purchasable = builder.purchasable;
        }
        if (builder.entitled != null) {
            this.entitled = builder.entitled;
        }
        if (builder.entitlementReason != null) {
            this.entitlementReason = builder.entitlementReason;
        }
        if (builder.activeEntitlementCount != null) {
            this.activeEntitlementCount = builder.activeEntitlementCount;
        }
        if (builder.purchaseMode != null) {
            this.purchaseMode = builder.purchaseMode;
        }
    }

    @JsonProperty(value="productId")
    public String getProductId() {
        return this.productId;
    }

    @JsonProperty(value="referenceName")
    public String getReferenceName() {
        return this.referenceName;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public ProductType getType() {
        return ProductType.fromValue(this.type);
    }

    @JsonProperty(value="type")
    public String getTypeAsString() {
        return this.type;
    }

    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    public PurchasableState getPurchasable() {
        return PurchasableState.fromValue(this.purchasable);
    }

    @JsonProperty(value="purchasable")
    public String getPurchasableAsString() {
        return this.purchasable;
    }

    public EntitledState getEntitled() {
        return EntitledState.fromValue(this.entitled);
    }

    @JsonProperty(value="entitled")
    public String getEntitledAsString() {
        return this.entitled;
    }

    public EntitlementReason getEntitlementReason() {
        return EntitlementReason.fromValue(this.entitlementReason);
    }

    @JsonProperty(value="entitlementReason")
    public String getEntitlementReasonAsString() {
        return this.entitlementReason;
    }

    @JsonProperty(value="activeEntitlementCount")
    public Integer getActiveEntitlementCount() {
        return this.activeEntitlementCount;
    }

    public PurchaseMode getPurchaseMode() {
        return PurchaseMode.fromValue(this.purchaseMode);
    }

    @JsonProperty(value="purchaseMode")
    public String getPurchaseModeAsString() {
        return this.purchaseMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InSkillProduct servicesMonetizationInSkillProduct = (InSkillProduct)o;
        return Objects.equals(this.productId, servicesMonetizationInSkillProduct.productId) && Objects.equals(this.referenceName, servicesMonetizationInSkillProduct.referenceName) && Objects.equals(this.name, servicesMonetizationInSkillProduct.name) && Objects.equals(this.type, servicesMonetizationInSkillProduct.type) && Objects.equals(this.summary, servicesMonetizationInSkillProduct.summary) && Objects.equals(this.purchasable, servicesMonetizationInSkillProduct.purchasable) && Objects.equals(this.entitled, servicesMonetizationInSkillProduct.entitled) && Objects.equals(this.entitlementReason, servicesMonetizationInSkillProduct.entitlementReason) && Objects.equals(this.activeEntitlementCount, servicesMonetizationInSkillProduct.activeEntitlementCount) && Objects.equals(this.purchaseMode, servicesMonetizationInSkillProduct.purchaseMode);
    }

    public int hashCode() {
        return Objects.hash(this.productId, this.referenceName, this.name, this.type, this.summary, this.purchasable, this.entitled, this.entitlementReason, this.activeEntitlementCount, this.purchaseMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InSkillProduct {\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    referenceName: ").append(this.toIndentedString(this.referenceName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    purchasable: ").append(this.toIndentedString(this.purchasable)).append("\n");
        sb.append("    entitled: ").append(this.toIndentedString(this.entitled)).append("\n");
        sb.append("    entitlementReason: ").append(this.toIndentedString(this.entitlementReason)).append("\n");
        sb.append("    activeEntitlementCount: ").append(this.toIndentedString(this.activeEntitlementCount)).append("\n");
        sb.append("    purchaseMode: ").append(this.toIndentedString(this.purchaseMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String productId;
        private String referenceName;
        private String name;
        private String type;
        private String summary;
        private String purchasable;
        private String entitled;
        private String entitlementReason;
        private Integer activeEntitlementCount;
        private String purchaseMode;

        private Builder() {
        }

        @JsonProperty(value="productId")
        public Builder withProductId(String productId) {
            this.productId = productId;
            return this;
        }

        @JsonProperty(value="referenceName")
        public Builder withReferenceName(String referenceName) {
            this.referenceName = referenceName;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withType(ProductType type) {
            this.type = type != null ? type.toString() : null;
            return this;
        }

        @JsonProperty(value="summary")
        public Builder withSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @JsonProperty(value="purchasable")
        public Builder withPurchasable(String purchasable) {
            this.purchasable = purchasable;
            return this;
        }

        public Builder withPurchasable(PurchasableState purchasable) {
            this.purchasable = purchasable != null ? purchasable.toString() : null;
            return this;
        }

        @JsonProperty(value="entitled")
        public Builder withEntitled(String entitled) {
            this.entitled = entitled;
            return this;
        }

        public Builder withEntitled(EntitledState entitled) {
            this.entitled = entitled != null ? entitled.toString() : null;
            return this;
        }

        @JsonProperty(value="entitlementReason")
        public Builder withEntitlementReason(String entitlementReason) {
            this.entitlementReason = entitlementReason;
            return this;
        }

        public Builder withEntitlementReason(EntitlementReason entitlementReason) {
            this.entitlementReason = entitlementReason != null ? entitlementReason.toString() : null;
            return this;
        }

        @JsonProperty(value="activeEntitlementCount")
        public Builder withActiveEntitlementCount(Integer activeEntitlementCount) {
            this.activeEntitlementCount = activeEntitlementCount;
            return this;
        }

        @JsonProperty(value="purchaseMode")
        public Builder withPurchaseMode(String purchaseMode) {
            this.purchaseMode = purchaseMode;
            return this;
        }

        public Builder withPurchaseMode(PurchaseMode purchaseMode) {
            this.purchaseMode = purchaseMode != null ? purchaseMode.toString() : null;
            return this;
        }

        public InSkillProduct build() {
            return new InSkillProduct(this);
        }
    }
}

