/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.directive;

import com.amazon.ask.model.services.directive.Directive;
import com.amazon.ask.model.services.directive.Header;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SendDirectiveRequest {
    @JsonProperty(value="header")
    private Header header = null;
    @JsonProperty(value="directive")
    private Directive directive = null;

    private SendDirectiveRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SendDirectiveRequest(Builder builder) {
        if (builder.header != null) {
            this.header = builder.header;
        }
        if (builder.directive != null) {
            this.directive = builder.directive;
        }
    }

    @JsonProperty(value="header")
    public Header getHeader() {
        return this.header;
    }

    @JsonProperty(value="directive")
    public Directive getDirective() {
        return this.directive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendDirectiveRequest servicesDirectiveSendDirectiveRequest = (SendDirectiveRequest)o;
        return Objects.equals(this.header, servicesDirectiveSendDirectiveRequest.header) && Objects.equals(this.directive, servicesDirectiveSendDirectiveRequest.directive);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.directive);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendDirectiveRequest {\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    directive: ").append(this.toIndentedString(this.directive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Header header;
        private Directive directive;

        private Builder() {
        }

        @JsonProperty(value="header")
        public Builder withHeader(Header header) {
            this.header = header;
            return this;
        }

        @JsonProperty(value="directive")
        public Builder withDirective(Directive directive) {
            this.directive = directive;
            return this;
        }

        public SendDirectiveRequest build() {
            return new SendDirectiveRequest(this);
        }
    }
}

