/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.directive;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.directive.DirectiveService;
import com.amazon.ask.model.services.directive.Error;
import com.amazon.ask.model.services.directive.SendDirectiveRequest;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class DirectiveServiceClient
extends BaseServiceClient
implements DirectiveService {
    private final UserAgentHelper userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.40.0").build();

    public DirectiveServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public ApiResponse<Void> callEnqueue(SendDirectiveRequest sendDirectiveRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/directives";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 204, "Directive sent successfully."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Directive not valid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Not Authorized."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The skill is not allowed to send directives at the moment."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Unexpected error."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, sendDirectiveRequest, null, false);
    }

    @Override
    public void enqueue(SendDirectiveRequest sendDirectiveRequest) throws ServiceException {
        this.callEnqueue(sendDirectiveRequest).getResponse();
    }
}

