/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.videoapp;

import com.amazon.ask.model.interfaces.videoapp.Metadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class VideoItem {
    @JsonProperty(value="source")
    private String source = null;
    @JsonProperty(value="metadata")
    private Metadata metadata = null;

    private VideoItem() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private VideoItem(Builder builder) {
        if (builder.source != null) {
            this.source = builder.source;
        }
        if (builder.metadata != null) {
            this.metadata = builder.metadata;
        }
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoItem interfacesVideoappVideoItem = (VideoItem)o;
        return Objects.equals(this.source, interfacesVideoappVideoItem.source) && Objects.equals(this.metadata, interfacesVideoappVideoItem.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoItem {\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String source;
        private Metadata metadata;

        private Builder() {
        }

        @JsonProperty(value="source")
        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        @JsonProperty(value="metadata")
        public Builder withMetadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public VideoItem build() {
            return new VideoItem(this);
        }
    }
}

