/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.display;

import com.amazon.ask.model.interfaces.display.TextField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class TextContent {
    @JsonProperty(value="primaryText")
    private TextField primaryText = null;
    @JsonProperty(value="secondaryText")
    private TextField secondaryText = null;
    @JsonProperty(value="tertiaryText")
    private TextField tertiaryText = null;

    private TextContent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private TextContent(Builder builder) {
        if (builder.primaryText != null) {
            this.primaryText = builder.primaryText;
        }
        if (builder.secondaryText != null) {
            this.secondaryText = builder.secondaryText;
        }
        if (builder.tertiaryText != null) {
            this.tertiaryText = builder.tertiaryText;
        }
    }

    @JsonProperty(value="primaryText")
    public TextField getPrimaryText() {
        return this.primaryText;
    }

    @JsonProperty(value="secondaryText")
    public TextField getSecondaryText() {
        return this.secondaryText;
    }

    @JsonProperty(value="tertiaryText")
    public TextField getTertiaryText() {
        return this.tertiaryText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextContent interfacesDisplayTextContent = (TextContent)o;
        return Objects.equals(this.primaryText, interfacesDisplayTextContent.primaryText) && Objects.equals(this.secondaryText, interfacesDisplayTextContent.secondaryText) && Objects.equals(this.tertiaryText, interfacesDisplayTextContent.tertiaryText);
    }

    public int hashCode() {
        return Objects.hash(this.primaryText, this.secondaryText, this.tertiaryText);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextContent {\n");
        sb.append("    primaryText: ").append(this.toIndentedString(this.primaryText)).append("\n");
        sb.append("    secondaryText: ").append(this.toIndentedString(this.secondaryText)).append("\n");
        sb.append("    tertiaryText: ").append(this.toIndentedString(this.tertiaryText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private TextField primaryText;
        private TextField secondaryText;
        private TextField tertiaryText;

        private Builder() {
        }

        @JsonProperty(value="primaryText")
        public Builder withPrimaryText(TextField primaryText) {
            this.primaryText = primaryText;
            return this;
        }

        @JsonProperty(value="secondaryText")
        public Builder withSecondaryText(TextField secondaryText) {
            this.secondaryText = secondaryText;
            return this;
        }

        @JsonProperty(value="tertiaryText")
        public Builder withTertiaryText(TextField tertiaryText) {
            this.tertiaryText = tertiaryText;
            return this;
        }

        public TextContent build() {
            return new TextContent(this);
        }
    }
}

