/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.connections.entities;

import com.amazon.ask.model.interfaces.connections.entities.BaseEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PostalAddress
extends BaseEntity {
    @JsonProperty(value="streetAddress")
    private String streetAddress = null;
    @JsonProperty(value="locality")
    private String locality = null;
    @JsonProperty(value="region")
    private String region = null;
    @JsonProperty(value="postalCode")
    private String postalCode = null;
    @JsonProperty(value="country")
    private String country = null;

    private PostalAddress() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private PostalAddress(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "PostalAddress";
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.streetAddress != null) {
            this.streetAddress = builder.streetAddress;
        }
        if (builder.locality != null) {
            this.locality = builder.locality;
        }
        if (builder.region != null) {
            this.region = builder.region;
        }
        if (builder.postalCode != null) {
            this.postalCode = builder.postalCode;
        }
        if (builder.country != null) {
            this.country = builder.country;
        }
    }

    @JsonProperty(value="streetAddress")
    public String getStreetAddress() {
        return this.streetAddress;
    }

    @JsonProperty(value="locality")
    public String getLocality() {
        return this.locality;
    }

    @JsonProperty(value="region")
    public String getRegion() {
        return this.region;
    }

    @JsonProperty(value="postalCode")
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostalAddress interfacesConnectionsEntitiesPostalAddress = (PostalAddress)o;
        return Objects.equals(this.streetAddress, interfacesConnectionsEntitiesPostalAddress.streetAddress) && Objects.equals(this.locality, interfacesConnectionsEntitiesPostalAddress.locality) && Objects.equals(this.region, interfacesConnectionsEntitiesPostalAddress.region) && Objects.equals(this.postalCode, interfacesConnectionsEntitiesPostalAddress.postalCode) && Objects.equals(this.country, interfacesConnectionsEntitiesPostalAddress.country) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.streetAddress, this.locality, this.region, this.postalCode, this.country, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostalAddress {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    streetAddress: ").append(this.toIndentedString(this.streetAddress)).append("\n");
        sb.append("    locality: ").append(this.toIndentedString(this.locality)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String version;
        private String streetAddress;
        private String locality;
        private String region;
        private String postalCode;
        private String country;

        private Builder() {
        }

        @JsonProperty(value="@version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="streetAddress")
        public Builder withStreetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        @JsonProperty(value="locality")
        public Builder withLocality(String locality) {
            this.locality = locality;
            return this;
        }

        @JsonProperty(value="region")
        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        @JsonProperty(value="postalCode")
        public Builder withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        @JsonProperty(value="country")
        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public PostalAddress build() {
            return new PostalAddress(this);
        }
    }
}

