/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.interfaces.audioplayer.CaptionData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Stream {
    @JsonProperty(value="expectedPreviousToken")
    private String expectedPreviousToken = null;
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="offsetInMilliseconds")
    private Long offsetInMilliseconds = null;
    @JsonProperty(value="captionData")
    private CaptionData captionData = null;

    private Stream() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Stream(Builder builder) {
        if (builder.expectedPreviousToken != null) {
            this.expectedPreviousToken = builder.expectedPreviousToken;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.url != null) {
            this.url = builder.url;
        }
        if (builder.offsetInMilliseconds != null) {
            this.offsetInMilliseconds = builder.offsetInMilliseconds;
        }
        if (builder.captionData != null) {
            this.captionData = builder.captionData;
        }
    }

    @JsonProperty(value="expectedPreviousToken")
    public String getExpectedPreviousToken() {
        return this.expectedPreviousToken;
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="offsetInMilliseconds")
    public Long getOffsetInMilliseconds() {
        return this.offsetInMilliseconds;
    }

    @JsonProperty(value="captionData")
    public CaptionData getCaptionData() {
        return this.captionData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stream interfacesAudioplayerStream = (Stream)o;
        return Objects.equals(this.expectedPreviousToken, interfacesAudioplayerStream.expectedPreviousToken) && Objects.equals(this.token, interfacesAudioplayerStream.token) && Objects.equals(this.url, interfacesAudioplayerStream.url) && Objects.equals(this.offsetInMilliseconds, interfacesAudioplayerStream.offsetInMilliseconds) && Objects.equals(this.captionData, interfacesAudioplayerStream.captionData);
    }

    public int hashCode() {
        return Objects.hash(this.expectedPreviousToken, this.token, this.url, this.offsetInMilliseconds, this.captionData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Stream {\n");
        sb.append("    expectedPreviousToken: ").append(this.toIndentedString(this.expectedPreviousToken)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    offsetInMilliseconds: ").append(this.toIndentedString(this.offsetInMilliseconds)).append("\n");
        sb.append("    captionData: ").append(this.toIndentedString(this.captionData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String expectedPreviousToken;
        private String token;
        private String url;
        private Long offsetInMilliseconds;
        private CaptionData captionData;

        private Builder() {
        }

        @JsonProperty(value="expectedPreviousToken")
        public Builder withExpectedPreviousToken(String expectedPreviousToken) {
            this.expectedPreviousToken = expectedPreviousToken;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="url")
        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="offsetInMilliseconds")
        public Builder withOffsetInMilliseconds(Long offsetInMilliseconds) {
            this.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }

        @JsonProperty(value="captionData")
        public Builder withCaptionData(CaptionData captionData) {
            this.captionData = captionData;
            return this;
        }

        public Stream build() {
            return new Stream(this);
        }
    }
}

