/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.html;

import com.amazon.ask.model.interfaces.alexa.presentation.html.TransformerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Transformer {
    @JsonProperty(value="transformer")
    private String transformer = null;
    @JsonProperty(value="inputPath")
    private String inputPath = null;
    @JsonProperty(value="outputName")
    private String outputName = null;

    private Transformer() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Transformer(Builder builder) {
        if (builder.transformer != null) {
            this.transformer = builder.transformer;
        }
        if (builder.inputPath != null) {
            this.inputPath = builder.inputPath;
        }
        if (builder.outputName != null) {
            this.outputName = builder.outputName;
        }
    }

    public TransformerType getTransformer() {
        return TransformerType.fromValue(this.transformer);
    }

    @JsonProperty(value="transformer")
    public String getTransformerAsString() {
        return this.transformer;
    }

    @JsonProperty(value="inputPath")
    public String getInputPath() {
        return this.inputPath;
    }

    @JsonProperty(value="outputName")
    public String getOutputName() {
        return this.outputName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transformer interfacesAlexaPresentationHtmlTransformer = (Transformer)o;
        return Objects.equals(this.transformer, interfacesAlexaPresentationHtmlTransformer.transformer) && Objects.equals(this.inputPath, interfacesAlexaPresentationHtmlTransformer.inputPath) && Objects.equals(this.outputName, interfacesAlexaPresentationHtmlTransformer.outputName);
    }

    public int hashCode() {
        return Objects.hash(this.transformer, this.inputPath, this.outputName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transformer {\n");
        sb.append("    transformer: ").append(this.toIndentedString(this.transformer)).append("\n");
        sb.append("    inputPath: ").append(this.toIndentedString(this.inputPath)).append("\n");
        sb.append("    outputName: ").append(this.toIndentedString(this.outputName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String transformer;
        private String inputPath;
        private String outputName;

        private Builder() {
        }

        @JsonProperty(value="transformer")
        public Builder withTransformer(String transformer) {
            this.transformer = transformer;
            return this;
        }

        public Builder withTransformer(TransformerType transformer) {
            this.transformer = transformer != null ? transformer.toString() : null;
            return this;
        }

        @JsonProperty(value="inputPath")
        public Builder withInputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        @JsonProperty(value="outputName")
        public Builder withOutputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public Transformer build() {
            return new Transformer(this);
        }
    }
}

