/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.ComponentVisibleOnScreen;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class RenderedDocumentState {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="componentsVisibleOnScreen")
    private List<ComponentVisibleOnScreen> componentsVisibleOnScreen = new ArrayList<ComponentVisibleOnScreen>();
    @JsonProperty(value="dataSources")
    private List<Object> dataSources = new ArrayList<Object>();

    private RenderedDocumentState() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RenderedDocumentState(Builder builder) {
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.componentsVisibleOnScreen != null) {
            this.componentsVisibleOnScreen = builder.componentsVisibleOnScreen;
        }
        if (builder.dataSources != null) {
            this.dataSources = builder.dataSources;
        }
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="componentsVisibleOnScreen")
    public List<ComponentVisibleOnScreen> getComponentsVisibleOnScreen() {
        return this.componentsVisibleOnScreen;
    }

    @JsonProperty(value="dataSources")
    public List<Object> getDataSources() {
        return this.dataSources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderedDocumentState interfacesAlexaPresentationAplRenderedDocumentState = (RenderedDocumentState)o;
        return Objects.equals(this.token, interfacesAlexaPresentationAplRenderedDocumentState.token) && Objects.equals(this.version, interfacesAlexaPresentationAplRenderedDocumentState.version) && Objects.equals(this.componentsVisibleOnScreen, interfacesAlexaPresentationAplRenderedDocumentState.componentsVisibleOnScreen) && Objects.equals(this.dataSources, interfacesAlexaPresentationAplRenderedDocumentState.dataSources);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.version, this.componentsVisibleOnScreen, this.dataSources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RenderedDocumentState {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    componentsVisibleOnScreen: ").append(this.toIndentedString(this.componentsVisibleOnScreen)).append("\n");
        sb.append("    dataSources: ").append(this.toIndentedString(this.dataSources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String token;
        private String version;
        private List<ComponentVisibleOnScreen> componentsVisibleOnScreen;
        private List<Object> dataSources;

        private Builder() {
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="componentsVisibleOnScreen")
        public Builder withComponentsVisibleOnScreen(List<ComponentVisibleOnScreen> componentsVisibleOnScreen) {
            this.componentsVisibleOnScreen = componentsVisibleOnScreen;
            return this;
        }

        public Builder addComponentsVisibleOnScreenItem(ComponentVisibleOnScreen componentsVisibleOnScreenItem) {
            if (this.componentsVisibleOnScreen == null) {
                this.componentsVisibleOnScreen = new ArrayList<ComponentVisibleOnScreen>();
            }
            this.componentsVisibleOnScreen.add(componentsVisibleOnScreenItem);
            return this;
        }

        @JsonProperty(value="dataSources")
        public Builder withDataSources(List<Object> dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public Builder addDataSourcesItem(Object dataSourcesItem) {
            if (this.dataSources == null) {
                this.dataSources = new ArrayList<Object>();
            }
            this.dataSources.add(dataSourcesItem);
            return this;
        }

        public RenderedDocumentState build() {
            return new RenderedDocumentState(this);
        }
    }
}

