/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.dynamicEndpoints;

import com.amazon.ask.model.dynamicEndpoints.BaseResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class FailureResponse
extends BaseResponse {
    @JsonProperty(value="errorCode")
    private String errorCode = null;
    @JsonProperty(value="errorMessage")
    private String errorMessage = null;

    private FailureResponse() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private FailureResponse(Builder builder) {
        String discriminatorValue = "SkillResponseFailureMessage";
        if (builder.version != null) {
            this.version = builder.version;
        }
        this.type = discriminatorValue;
        if (builder.originalRequestId != null) {
            this.originalRequestId = builder.originalRequestId;
        }
        if (builder.errorCode != null) {
            this.errorCode = builder.errorCode;
        }
        if (builder.errorMessage != null) {
            this.errorMessage = builder.errorMessage;
        }
    }

    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailureResponse dynamicEndpointsFailureResponse = (FailureResponse)o;
        return Objects.equals(this.errorCode, dynamicEndpointsFailureResponse.errorCode) && Objects.equals(this.errorMessage, dynamicEndpointsFailureResponse.errorMessage) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.errorCode, this.errorMessage, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FailureResponse {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String version;
        private String originalRequestId;
        private String errorCode;
        private String errorMessage;

        private Builder() {
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="originalRequestId")
        public Builder withOriginalRequestId(String originalRequestId) {
            this.originalRequestId = originalRequestId;
            return this;
        }

        @JsonProperty(value="errorCode")
        public Builder withErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @JsonProperty(value="errorMessage")
        public Builder withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public FailureResponse build() {
            return new FailureResponse(this);
        }
    }
}

