/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.ui;

import com.amazon.ask.model.Directive;
import com.amazon.ask.model.ui.OutputSpeech;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Reprompt {
    @JsonProperty(value="outputSpeech")
    private OutputSpeech outputSpeech = null;
    @JsonProperty(value="directives")
    private List<Directive> directives = new ArrayList<Directive>();

    public static Builder builder() {
        return new Builder();
    }

    private Reprompt(Builder builder) {
        if (builder.outputSpeech != null) {
            this.outputSpeech = builder.outputSpeech;
        }
        if (builder.directives != null) {
            this.directives = builder.directives;
        }
    }

    @JsonProperty(value="outputSpeech")
    public OutputSpeech getOutputSpeech() {
        return this.outputSpeech;
    }

    @JsonProperty(value="directives")
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reprompt uiReprompt = (Reprompt)o;
        return Objects.equals(this.outputSpeech, uiReprompt.outputSpeech) && Objects.equals(this.directives, uiReprompt.directives);
    }

    public int hashCode() {
        return Objects.hash(this.outputSpeech, this.directives);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reprompt {\n");
        sb.append("    outputSpeech: ").append(this.toIndentedString(this.outputSpeech)).append("\n");
        sb.append("    directives: ").append(this.toIndentedString(this.directives)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private OutputSpeech outputSpeech;
        private List<Directive> directives;

        private Builder() {
        }

        @JsonProperty(value="outputSpeech")
        public Builder withOutputSpeech(OutputSpeech outputSpeech) {
            this.outputSpeech = outputSpeech;
            return this;
        }

        @JsonProperty(value="directives")
        public Builder withDirectives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder addDirectivesItem(Directive directivesItem) {
            if (this.directives == null) {
                this.directives = new ArrayList<Directive>();
            }
            this.directives.add(directivesItem);
            return this;
        }

        public Reprompt build() {
            return new Reprompt(this);
        }
    }
}

