/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.ups;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.ups.DistanceUnits;
import com.amazon.ask.model.services.ups.Error;
import com.amazon.ask.model.services.ups.PhoneNumber;
import com.amazon.ask.model.services.ups.TemperatureUnit;
import com.amazon.ask.model.services.ups.UpsService;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class UpsServiceClient
extends BaseServiceClient
implements UpsService {
    private final UserAgentHelper userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.37.0").build();

    public UpsServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public ApiResponse<String> callGetProfileEmail() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/accounts/~current/settings/Profile.email";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class, false);
    }

    @Override
    public String getProfileEmail() throws ServiceException {
        return (String)this.callGetProfileEmail().getResponse();
    }

    @Override
    public ApiResponse<String> callGetProfileGivenName() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/accounts/~current/settings/Profile.givenName";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class, false);
    }

    @Override
    public String getProfileGivenName() throws ServiceException {
        return (String)this.callGetProfileGivenName().getResponse();
    }

    @Override
    public ApiResponse<PhoneNumber> callGetProfileMobileNumber() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/accounts/~current/settings/Profile.mobileNumber";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(PhoneNumber.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, PhoneNumber.class, false);
    }

    @Override
    public PhoneNumber getProfileMobileNumber() throws ServiceException {
        return (PhoneNumber)this.callGetProfileMobileNumber().getResponse();
    }

    @Override
    public ApiResponse<String> callGetProfileName() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/accounts/~current/settings/Profile.name";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class, false);
    }

    @Override
    public String getProfileName() throws ServiceException {
        return (String)this.callGetProfileName().getResponse();
    }

    @Override
    public ApiResponse<DistanceUnits> callGetSystemDistanceUnits(String deviceId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("deviceId", deviceId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/devices/{deviceId}/settings/System.distanceUnits";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(DistanceUnits.class, 200, "Successfully get the setting"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, DistanceUnits.class, false);
    }

    @Override
    public DistanceUnits getSystemDistanceUnits(String deviceId) throws ServiceException {
        return (DistanceUnits)((Object)this.callGetSystemDistanceUnits(deviceId).getResponse());
    }

    @Override
    public ApiResponse<TemperatureUnit> callGetSystemTemperatureUnit(String deviceId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("deviceId", deviceId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/devices/{deviceId}/settings/System.temperatureUnit";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(TemperatureUnit.class, 200, "Successfully get the setting"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, TemperatureUnit.class, false);
    }

    @Override
    public TemperatureUnit getSystemTemperatureUnit(String deviceId) throws ServiceException {
        return (TemperatureUnit)((Object)this.callGetSystemTemperatureUnit(deviceId).getResponse());
    }

    @Override
    public ApiResponse<String> callGetSystemTimeZone(String deviceId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("deviceId", deviceId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/devices/{deviceId}/settings/System.timeZone";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully get the setting"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class, false);
    }

    @Override
    public String getSystemTimeZone(String deviceId) throws ServiceException {
        return (String)this.callGetSystemTimeZone(deviceId).getResponse();
    }

    @Override
    public ApiResponse<String> callGetPersonsProfileGivenName() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/persons/~current/profile/givenName";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class, false);
    }

    @Override
    public String getPersonsProfileGivenName() throws ServiceException {
        return (String)this.callGetPersonsProfileGivenName().getResponse();
    }

    @Override
    public ApiResponse<PhoneNumber> callGetPersonsProfileMobileNumber() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/persons/~current/profile/mobileNumber";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(PhoneNumber.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, PhoneNumber.class, false);
    }

    @Override
    public PhoneNumber getPersonsProfileMobileNumber() throws ServiceException {
        return (PhoneNumber)this.callGetPersonsProfileMobileNumber().getResponse();
    }

    @Override
    public ApiResponse<String> callGetPersonsProfileName() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/persons/~current/profile/name";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class, false);
    }

    @Override
    public String getPersonsProfileName() throws ServiceException {
        return (String)this.callGetPersonsProfileName().getResponse();
    }
}

