/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.timerManagement;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Task {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="input")
    private Object input = null;

    public static Builder builder() {
        return new Builder();
    }

    private Task(Builder builder) {
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.input != null) {
            this.input = builder.input;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="input")
    public Object getInput() {
        return this.input;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task servicesTimerManagementTask = (Task)o;
        return Objects.equals(this.name, servicesTimerManagementTask.name) && Objects.equals(this.version, servicesTimerManagementTask.version) && Objects.equals(this.input, servicesTimerManagementTask.input);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.input);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Task {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private String version;
        private Object input;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="input")
        public Builder withInput(Object input) {
            this.input = input;
            return this;
        }

        public Task build() {
            return new Task(this);
        }
    }
}

