/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.reminderManagement.Error;
import com.amazon.ask.model.services.reminderManagement.GetReminderResponse;
import com.amazon.ask.model.services.reminderManagement.GetRemindersResponse;
import com.amazon.ask.model.services.reminderManagement.ReminderManagementService;
import com.amazon.ask.model.services.reminderManagement.ReminderRequest;
import com.amazon.ask.model.services.reminderManagement.ReminderResponse;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class ReminderManagementServiceClient
extends BaseServiceClient
implements ReminderManagementService {
    private final UserAgentHelper userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.37.0").build();

    public ReminderManagementServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public ApiResponse<Void> callDeleteReminder(String alertToken) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("alertToken", alertToken);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/reminders/{alertToken}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "UserAuthenticationException. Request is not authorized/authenticated e.g. If customer does not have permission to create a reminder."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("DELETE", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null, false);
    }

    @Override
    public void deleteReminder(String alertToken) throws ServiceException {
        this.callDeleteReminder(alertToken).getResponse();
    }

    @Override
    public ApiResponse<GetReminderResponse> callGetReminder(String alertToken) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("alertToken", alertToken);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/reminders/{alertToken}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(GetReminderResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "UserAuthenticationException. Request is not authorized/authenticated e.g. If customer does not have permission to create a reminder."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, GetReminderResponse.class, false);
    }

    @Override
    public GetReminderResponse getReminder(String alertToken) throws ServiceException {
        return (GetReminderResponse)this.callGetReminder(alertToken).getResponse();
    }

    @Override
    public ApiResponse<ReminderResponse> callUpdateReminder(String alertToken, ReminderRequest reminderRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("alertToken", alertToken);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/reminders/{alertToken}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(ReminderResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "NotFoundException e.g. Retured when reminder is not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "UserAuthenticationException. Request is not authorized/authenticated e.g. If customer does not have permission to create a reminder."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("PUT", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, reminderRequest, ReminderResponse.class, false);
    }

    @Override
    public ReminderResponse updateReminder(String alertToken, ReminderRequest reminderRequest) throws ServiceException {
        return (ReminderResponse)this.callUpdateReminder(alertToken, reminderRequest).getResponse();
    }

    @Override
    public ApiResponse<GetRemindersResponse> callGetReminders() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/reminders";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(GetRemindersResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "UserAuthenticationException. Request is not authorized/authenticated e.g. If customer does not have permission to create a reminder."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, GetRemindersResponse.class, false);
    }

    @Override
    public GetRemindersResponse getReminders() throws ServiceException {
        return (GetRemindersResponse)this.callGetReminders().getResponse();
    }

    @Override
    public ApiResponse<ReminderResponse> callCreateReminder(ReminderRequest reminderRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/alerts/reminders";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(ReminderResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 503, "Service Unavailable"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 504, "Gateway Timeout"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, reminderRequest, ReminderResponse.class, false);
    }

    @Override
    public ReminderResponse createReminder(ReminderRequest reminderRequest) throws ServiceException {
        return (ReminderResponse)this.callCreateReminder(reminderRequest).getResponse();
    }
}

