/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.listManagement.ListState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class UpdateListRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="version")
    private Long version = null;

    public static Builder builder() {
        return new Builder();
    }

    private UpdateListRequest(Builder builder) {
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.state != null) {
            this.state = builder.state;
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public ListState getState() {
        return ListState.fromValue(this.state);
    }

    @JsonProperty(value="state")
    public String getStateAsString() {
        return this.state;
    }

    @JsonProperty(value="version")
    public Long getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateListRequest servicesListManagementUpdateListRequest = (UpdateListRequest)o;
        return Objects.equals(this.name, servicesListManagementUpdateListRequest.name) && Objects.equals(this.state, servicesListManagementUpdateListRequest.state) && Objects.equals(this.version, servicesListManagementUpdateListRequest.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.state, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateListRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private String state;
        private Long version;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="state")
        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withState(ListState state) {
            this.state = state != null ? state.toString() : null;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        public UpdateListRequest build() {
            return new UpdateListRequest(this);
        }
    }
}

