/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.listManagement.AlexaList;
import com.amazon.ask.model.services.listManagement.AlexaListItem;
import com.amazon.ask.model.services.listManagement.AlexaListMetadata;
import com.amazon.ask.model.services.listManagement.AlexaListsMetadata;
import com.amazon.ask.model.services.listManagement.CreateListItemRequest;
import com.amazon.ask.model.services.listManagement.CreateListRequest;
import com.amazon.ask.model.services.listManagement.Error;
import com.amazon.ask.model.services.listManagement.ForbiddenError;
import com.amazon.ask.model.services.listManagement.ListManagementService;
import com.amazon.ask.model.services.listManagement.UpdateListItemRequest;
import com.amazon.ask.model.services.listManagement.UpdateListRequest;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class ListManagementServiceClient
extends BaseServiceClient
implements ListManagementService {
    private final UserAgentHelper userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.37.0").build();

    public ListManagementServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public ApiResponse<AlexaListsMetadata> callGetListsMetadata() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListsMetadata.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(ForbiddenError.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, AlexaListsMetadata.class, false);
    }

    @Override
    public AlexaListsMetadata getListsMetadata() throws ServiceException {
        return (AlexaListsMetadata)this.callGetListsMetadata().getResponse();
    }

    @Override
    public ApiResponse<Void> callDeleteList(String listId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists/{listId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("DELETE", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null, false);
    }

    @Override
    public void deleteList(String listId) throws ServiceException {
        this.callDeleteList(listId).getResponse();
    }

    @Override
    public ApiResponse<Void> callDeleteListItem(String listId, String itemId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        pathParams.put("itemId", itemId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists/{listId}/items/{itemId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("DELETE", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null, false);
    }

    @Override
    public void deleteListItem(String listId, String itemId) throws ServiceException {
        this.callDeleteListItem(listId, itemId).getResponse();
    }

    @Override
    public ApiResponse<AlexaListItem> callGetListItem(String listId, String itemId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        pathParams.put("itemId", itemId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists/{listId}/items/{itemId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListItem.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, AlexaListItem.class, false);
    }

    @Override
    public AlexaListItem getListItem(String listId, String itemId) throws ServiceException {
        return (AlexaListItem)this.callGetListItem(listId, itemId).getResponse();
    }

    @Override
    public ApiResponse<AlexaListItem> callUpdateListItem(String listId, String itemId, UpdateListItemRequest updateListItemRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        pathParams.put("itemId", itemId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists/{listId}/items/{itemId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListItem.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "Conflict"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("PUT", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, updateListItemRequest, AlexaListItem.class, false);
    }

    @Override
    public AlexaListItem updateListItem(String listId, String itemId, UpdateListItemRequest updateListItemRequest) throws ServiceException {
        return (AlexaListItem)this.callUpdateListItem(listId, itemId, updateListItemRequest).getResponse();
    }

    @Override
    public ApiResponse<AlexaListItem> callCreateListItem(String listId, CreateListItemRequest createListItemRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists/{listId}/items";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListItem.class, 201, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, createListItemRequest, AlexaListItem.class, false);
    }

    @Override
    public AlexaListItem createListItem(String listId, CreateListItemRequest createListItemRequest) throws ServiceException {
        return (AlexaListItem)this.callCreateListItem(listId, createListItemRequest).getResponse();
    }

    @Override
    public ApiResponse<AlexaListMetadata> callUpdateList(String listId, UpdateListRequest updateListRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists/{listId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListMetadata.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "List not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "Conflict"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("PUT", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, updateListRequest, AlexaListMetadata.class, false);
    }

    @Override
    public AlexaListMetadata updateList(String listId, UpdateListRequest updateListRequest) throws ServiceException {
        return (AlexaListMetadata)this.callUpdateList(listId, updateListRequest).getResponse();
    }

    @Override
    public ApiResponse<AlexaList> callGetList(String listId, String status) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        pathParams.put("status", status);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists/{listId}/{status}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaList.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, AlexaList.class, false);
    }

    @Override
    public AlexaList getList(String listId, String status) throws ServiceException {
        return (AlexaList)this.callGetList(listId, status).getResponse();
    }

    @Override
    public ApiResponse<AlexaListMetadata> callCreateList(CreateListRequest createListRequest) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v2/householdlists";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListMetadata.class, 201, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "Conflict"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("POST", "https://api.amazonalexa.com/", resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, createListRequest, AlexaListMetadata.class, false);
    }

    @Override
    public AlexaListMetadata createList(CreateListRequest createListRequest) throws ServiceException {
        return (AlexaListMetadata)this.callCreateList(createListRequest).getResponse();
    }
}

