/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.conversations;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.interfaces.conversations.APIRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class APIInvocationRequest
extends Request {
    @JsonProperty(value="apiRequest")
    private APIRequest apiRequest = null;

    public static Builder builder() {
        return new Builder();
    }

    private APIInvocationRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Dialog.API.Invoked";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.apiRequest != null) {
            this.apiRequest = builder.apiRequest;
        }
    }

    @JsonProperty(value="apiRequest")
    public APIRequest getApiRequest() {
        return this.apiRequest;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIInvocationRequest interfacesConversationsAPIInvocationRequest = (APIInvocationRequest)o;
        return Objects.equals(this.apiRequest, interfacesConversationsAPIInvocationRequest.apiRequest) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiRequest, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIInvocationRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    apiRequest: ").append(this.toIndentedString(this.apiRequest)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private APIRequest apiRequest;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="apiRequest")
        public Builder withApiRequest(APIRequest apiRequest) {
            this.apiRequest = apiRequest;
            return this;
        }

        public APIInvocationRequest build() {
            return new APIInvocationRequest(this);
        }
    }
}

