/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.interfaces.audioplayer.PlayerActivity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class CurrentPlaybackState {
    @JsonProperty(value="offsetInMilliseconds")
    private Long offsetInMilliseconds = null;
    @JsonProperty(value="playerActivity")
    private String playerActivity = null;
    @JsonProperty(value="token")
    private String token = null;

    public static Builder builder() {
        return new Builder();
    }

    private CurrentPlaybackState(Builder builder) {
        if (builder.offsetInMilliseconds != null) {
            this.offsetInMilliseconds = builder.offsetInMilliseconds;
        }
        if (builder.playerActivity != null) {
            this.playerActivity = builder.playerActivity;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
    }

    @JsonProperty(value="offsetInMilliseconds")
    public Long getOffsetInMilliseconds() {
        return this.offsetInMilliseconds;
    }

    public PlayerActivity getPlayerActivity() {
        return PlayerActivity.fromValue(this.playerActivity);
    }

    @JsonProperty(value="playerActivity")
    public String getPlayerActivityAsString() {
        return this.playerActivity;
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentPlaybackState interfacesAudioplayerCurrentPlaybackState = (CurrentPlaybackState)o;
        return Objects.equals(this.offsetInMilliseconds, interfacesAudioplayerCurrentPlaybackState.offsetInMilliseconds) && Objects.equals(this.playerActivity, interfacesAudioplayerCurrentPlaybackState.playerActivity) && Objects.equals(this.token, interfacesAudioplayerCurrentPlaybackState.token);
    }

    public int hashCode() {
        return Objects.hash(this.offsetInMilliseconds, this.playerActivity, this.token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CurrentPlaybackState {\n");
        sb.append("    offsetInMilliseconds: ").append(this.toIndentedString(this.offsetInMilliseconds)).append("\n");
        sb.append("    playerActivity: ").append(this.toIndentedString(this.playerActivity)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Long offsetInMilliseconds;
        private String playerActivity;
        private String token;

        private Builder() {
        }

        @JsonProperty(value="offsetInMilliseconds")
        public Builder withOffsetInMilliseconds(Long offsetInMilliseconds) {
            this.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }

        @JsonProperty(value="playerActivity")
        public Builder withPlayerActivity(String playerActivity) {
            this.playerActivity = playerActivity;
            return this;
        }

        public Builder withPlayerActivity(PlayerActivity playerActivity) {
            this.playerActivity = playerActivity != null ? playerActivity.toString() : null;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public CurrentPlaybackState build() {
            return new CurrentPlaybackState(this);
        }
    }
}

