/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.interfaces.audioplayer.PlayerActivity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AudioPlayerState {
    @JsonProperty(value="offsetInMilliseconds")
    private Long offsetInMilliseconds = null;
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="playerActivity")
    private String playerActivity = null;

    public static Builder builder() {
        return new Builder();
    }

    private AudioPlayerState(Builder builder) {
        if (builder.offsetInMilliseconds != null) {
            this.offsetInMilliseconds = builder.offsetInMilliseconds;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.playerActivity != null) {
            this.playerActivity = builder.playerActivity;
        }
    }

    @JsonProperty(value="offsetInMilliseconds")
    public Long getOffsetInMilliseconds() {
        return this.offsetInMilliseconds;
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    public PlayerActivity getPlayerActivity() {
        return PlayerActivity.fromValue(this.playerActivity);
    }

    @JsonProperty(value="playerActivity")
    public String getPlayerActivityAsString() {
        return this.playerActivity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioPlayerState interfacesAudioplayerAudioPlayerState = (AudioPlayerState)o;
        return Objects.equals(this.offsetInMilliseconds, interfacesAudioplayerAudioPlayerState.offsetInMilliseconds) && Objects.equals(this.token, interfacesAudioplayerAudioPlayerState.token) && Objects.equals(this.playerActivity, interfacesAudioplayerAudioPlayerState.playerActivity);
    }

    public int hashCode() {
        return Objects.hash(this.offsetInMilliseconds, this.token, this.playerActivity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudioPlayerState {\n");
        sb.append("    offsetInMilliseconds: ").append(this.toIndentedString(this.offsetInMilliseconds)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    playerActivity: ").append(this.toIndentedString(this.playerActivity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Long offsetInMilliseconds;
        private String token;
        private String playerActivity;

        private Builder() {
        }

        @JsonProperty(value="offsetInMilliseconds")
        public Builder withOffsetInMilliseconds(Long offsetInMilliseconds) {
            this.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="playerActivity")
        public Builder withPlayerActivity(String playerActivity) {
            this.playerActivity = playerActivity;
            return this;
        }

        public Builder withPlayerActivity(PlayerActivity playerActivity) {
            this.playerActivity = playerActivity != null ? playerActivity.toString() : null;
            return this;
        }

        public AudioPlayerState build() {
            return new AudioPlayerState(this);
        }
    }
}

