/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.applink;

import com.amazon.ask.model.interfaces.applink.CatalogTypes;
import com.amazon.ask.model.interfaces.applink.DirectLaunch;
import com.amazon.ask.model.interfaces.applink.SendToDevice;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AppLinkState {
    @JsonProperty(value="supportedCatalogTypes")
    private List<CatalogTypes> supportedCatalogTypes = new ArrayList<CatalogTypes>();
    @JsonProperty(value="directLaunch")
    private DirectLaunch directLaunch = null;
    @JsonProperty(value="sendToDevice")
    private SendToDevice sendToDevice = null;

    public static Builder builder() {
        return new Builder();
    }

    private AppLinkState(Builder builder) {
        if (builder.supportedCatalogTypes != null) {
            this.supportedCatalogTypes = builder.supportedCatalogTypes;
        }
        if (builder.directLaunch != null) {
            this.directLaunch = builder.directLaunch;
        }
        if (builder.sendToDevice != null) {
            this.sendToDevice = builder.sendToDevice;
        }
    }

    @JsonProperty(value="supportedCatalogTypes")
    public List<CatalogTypes> getSupportedCatalogTypes() {
        return this.supportedCatalogTypes;
    }

    @JsonProperty(value="directLaunch")
    public DirectLaunch getDirectLaunch() {
        return this.directLaunch;
    }

    @JsonProperty(value="sendToDevice")
    public SendToDevice getSendToDevice() {
        return this.sendToDevice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppLinkState interfacesApplinkAppLinkState = (AppLinkState)o;
        return Objects.equals(this.supportedCatalogTypes, interfacesApplinkAppLinkState.supportedCatalogTypes) && Objects.equals(this.directLaunch, interfacesApplinkAppLinkState.directLaunch) && Objects.equals(this.sendToDevice, interfacesApplinkAppLinkState.sendToDevice);
    }

    public int hashCode() {
        return Objects.hash(this.supportedCatalogTypes, this.directLaunch, this.sendToDevice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppLinkState {\n");
        sb.append("    supportedCatalogTypes: ").append(this.toIndentedString(this.supportedCatalogTypes)).append("\n");
        sb.append("    directLaunch: ").append(this.toIndentedString(this.directLaunch)).append("\n");
        sb.append("    sendToDevice: ").append(this.toIndentedString(this.sendToDevice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<CatalogTypes> supportedCatalogTypes;
        private DirectLaunch directLaunch;
        private SendToDevice sendToDevice;

        private Builder() {
        }

        @JsonProperty(value="supportedCatalogTypes")
        public Builder withSupportedCatalogTypes(List<CatalogTypes> supportedCatalogTypes) {
            this.supportedCatalogTypes = supportedCatalogTypes;
            return this;
        }

        public Builder addSupportedCatalogTypesItem(CatalogTypes supportedCatalogTypesItem) {
            if (this.supportedCatalogTypes == null) {
                this.supportedCatalogTypes = new ArrayList<CatalogTypes>();
            }
            this.supportedCatalogTypes.add(supportedCatalogTypesItem);
            return this;
        }

        @JsonProperty(value="directLaunch")
        public Builder withDirectLaunch(DirectLaunch directLaunch) {
            this.directLaunch = directLaunch;
            return this;
        }

        @JsonProperty(value="sendToDevice")
        public Builder withSendToDevice(SendToDevice sendToDevice) {
            this.sendToDevice = sendToDevice;
            return this;
        }

        public AppLinkState build() {
            return new AppLinkState(this);
        }
    }
}

