/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class VideoSource {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="duration")
    private String duration = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="repeatCount")
    private String repeatCount = null;
    @JsonProperty(value="offset")
    private String offset = null;

    public static Builder builder() {
        return new Builder();
    }

    private VideoSource(Builder builder) {
        if (builder.description != null) {
            this.description = builder.description;
        }
        if (builder.duration != null) {
            this.duration = builder.duration;
        }
        if (builder.url != null) {
            this.url = builder.url;
        }
        if (builder.repeatCount != null) {
            this.repeatCount = builder.repeatCount;
        }
        if (builder.offset != null) {
            this.offset = builder.offset;
        }
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="duration")
    public String getDuration() {
        return this.duration;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="repeatCount")
    public String getRepeatCount() {
        return this.repeatCount;
    }

    @JsonProperty(value="offset")
    public String getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSource interfacesAlexaPresentationAplVideoSource = (VideoSource)o;
        return Objects.equals(this.description, interfacesAlexaPresentationAplVideoSource.description) && Objects.equals(this.duration, interfacesAlexaPresentationAplVideoSource.duration) && Objects.equals(this.url, interfacesAlexaPresentationAplVideoSource.url) && Objects.equals(this.repeatCount, interfacesAlexaPresentationAplVideoSource.repeatCount) && Objects.equals(this.offset, interfacesAlexaPresentationAplVideoSource.offset);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.duration, this.url, this.repeatCount, this.offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSource {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    repeatCount: ").append(this.toIndentedString(this.repeatCount)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String description;
        private String duration;
        private String url;
        private String repeatCount;
        private String offset;

        private Builder() {
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(Integer duration) {
            this.duration = String.valueOf(duration);
            return this;
        }

        public Builder withDuration(String durationExpression) {
            this.duration = durationExpression;
            return this;
        }

        @JsonProperty(value="url")
        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="repeatCount")
        public Builder withRepeatCount(Integer repeatCount) {
            this.repeatCount = String.valueOf(repeatCount);
            return this;
        }

        public Builder withRepeatCount(String repeatCountExpression) {
            this.repeatCount = repeatCountExpression;
            return this;
        }

        @JsonProperty(value="offset")
        public Builder withOffset(Integer offset) {
            this.offset = String.valueOf(offset);
            return this;
        }

        public Builder withOffset(String offsetExpression) {
            this.offset = offsetExpression;
            return this;
        }

        public VideoSource build() {
            return new VideoSource(this);
        }
    }
}

