/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.Command;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SelectCommand
extends Command {
    @JsonProperty(value="commands")
    private List<Command> commands = new ArrayList<Command>();
    @JsonProperty(value="data")
    private List<Object> data = new ArrayList<Object>();
    @JsonProperty(value="otherwise")
    private List<Command> otherwise = new ArrayList<Command>();

    public static Builder builder() {
        return new Builder();
    }

    private SelectCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Select";
        if (builder.delay != null) {
            this.delay = builder.delay;
        }
        if (builder.description != null) {
            this.description = builder.description;
        }
        if (builder.screenLock != null) {
            this.screenLock = builder.screenLock;
        }
        if (builder.sequencer != null) {
            this.sequencer = builder.sequencer;
        }
        if (builder.when != null) {
            this.when = builder.when;
        }
        if (builder.commands != null) {
            this.commands = builder.commands;
        }
        if (builder.data != null) {
            this.data = builder.data;
        }
        if (builder.otherwise != null) {
            this.otherwise = builder.otherwise;
        }
    }

    @JsonProperty(value="commands")
    public List<Command> getCommands() {
        return this.commands;
    }

    @JsonProperty(value="data")
    public List<Object> getData() {
        return this.data;
    }

    @JsonProperty(value="otherwise")
    public List<Command> getOtherwise() {
        return this.otherwise;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectCommand interfacesAlexaPresentationAplSelectCommand = (SelectCommand)o;
        return Objects.equals(this.commands, interfacesAlexaPresentationAplSelectCommand.commands) && Objects.equals(this.data, interfacesAlexaPresentationAplSelectCommand.data) && Objects.equals(this.otherwise, interfacesAlexaPresentationAplSelectCommand.otherwise) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.commands, this.data, this.otherwise, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SelectCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    commands: ").append(this.toIndentedString(this.commands)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    otherwise: ").append(this.toIndentedString(this.otherwise)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String delay;
        private String description;
        private Boolean screenLock;
        private String sequencer;
        private Boolean when;
        private List<Command> commands;
        private List<Object> data;
        private List<Command> otherwise;

        private Builder() {
        }

        @JsonProperty(value="delay")
        public Builder withDelay(Integer delay) {
            this.delay = String.valueOf(delay);
            return this;
        }

        public Builder withDelay(String delayExpression) {
            this.delay = delayExpression;
            return this;
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="screenLock")
        public Builder withScreenLock(Boolean screenLock) {
            this.screenLock = screenLock;
            return this;
        }

        @JsonProperty(value="sequencer")
        public Builder withSequencer(String sequencer) {
            this.sequencer = sequencer;
            return this;
        }

        @JsonProperty(value="when")
        public Builder withWhen(Boolean when) {
            this.when = when;
            return this;
        }

        @JsonProperty(value="commands")
        public Builder withCommands(List<Command> commands) {
            this.commands = commands;
            return this;
        }

        public Builder addCommandsItem(Command commandsItem) {
            if (this.commands == null) {
                this.commands = new ArrayList<Command>();
            }
            this.commands.add(commandsItem);
            return this;
        }

        @JsonProperty(value="data")
        public Builder withData(List<Object> data) {
            this.data = data;
            return this;
        }

        public Builder addDataItem(Object dataItem) {
            if (this.data == null) {
                this.data = new ArrayList<Object>();
            }
            this.data.add(dataItem);
            return this;
        }

        @JsonProperty(value="otherwise")
        public Builder withOtherwise(List<Command> otherwise) {
            this.otherwise = otherwise;
            return this;
        }

        public Builder addOtherwiseItem(Command otherwiseItem) {
            if (this.otherwise == null) {
                this.otherwise = new ArrayList<Command>();
            }
            this.otherwise.add(otherwiseItem);
            return this;
        }

        public SelectCommand build() {
            return new SelectCommand(this);
        }
    }
}

