/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.AnimateItemRepeatMode;
import com.amazon.ask.model.interfaces.alexa.presentation.apl.AnimatedProperty;
import com.amazon.ask.model.interfaces.alexa.presentation.apl.Command;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AnimateItemCommand
extends Command {
    @JsonProperty(value="componentId")
    private String componentId = null;
    @JsonProperty(value="duration")
    private String duration = null;
    @JsonProperty(value="easing")
    private String easing = "linear";
    @JsonProperty(value="repeatCount")
    private String repeatCount = null;
    @JsonProperty(value="repeatMode")
    private AnimateItemRepeatMode repeatMode = null;
    @JsonProperty(value="value")
    private List<AnimatedProperty> value = new ArrayList<AnimatedProperty>();

    public static Builder builder() {
        return new Builder();
    }

    private AnimateItemCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "AnimateItem";
        if (builder.delay != null) {
            this.delay = builder.delay;
        }
        if (builder.description != null) {
            this.description = builder.description;
        }
        if (builder.screenLock != null) {
            this.screenLock = builder.screenLock;
        }
        if (builder.sequencer != null) {
            this.sequencer = builder.sequencer;
        }
        if (builder.when != null) {
            this.when = builder.when;
        }
        if (builder.componentId != null) {
            this.componentId = builder.componentId;
        }
        if (builder.duration != null) {
            this.duration = builder.duration;
        }
        if (builder.easing != null) {
            this.easing = builder.easing;
        }
        if (builder.repeatCount != null) {
            this.repeatCount = builder.repeatCount;
        }
        if (builder.repeatMode != null) {
            this.repeatMode = builder.repeatMode;
        }
        if (builder.value != null) {
            this.value = builder.value;
        }
    }

    @JsonProperty(value="componentId")
    public String getComponentId() {
        return this.componentId;
    }

    @JsonProperty(value="duration")
    public String getDuration() {
        return this.duration;
    }

    @JsonProperty(value="easing")
    public String getEasing() {
        return this.easing;
    }

    @JsonProperty(value="repeatCount")
    public String getRepeatCount() {
        return this.repeatCount;
    }

    @JsonProperty(value="repeatMode")
    public AnimateItemRepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    @JsonProperty(value="value")
    public List<AnimatedProperty> getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnimateItemCommand interfacesAlexaPresentationAplAnimateItemCommand = (AnimateItemCommand)o;
        return Objects.equals(this.componentId, interfacesAlexaPresentationAplAnimateItemCommand.componentId) && Objects.equals(this.duration, interfacesAlexaPresentationAplAnimateItemCommand.duration) && Objects.equals(this.easing, interfacesAlexaPresentationAplAnimateItemCommand.easing) && Objects.equals(this.repeatCount, interfacesAlexaPresentationAplAnimateItemCommand.repeatCount) && Objects.equals((Object)this.repeatMode, (Object)interfacesAlexaPresentationAplAnimateItemCommand.repeatMode) && Objects.equals(this.value, interfacesAlexaPresentationAplAnimateItemCommand.value) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.componentId, this.duration, this.easing, this.repeatCount, this.repeatMode, this.value, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnimateItemCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    componentId: ").append(this.toIndentedString(this.componentId)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    easing: ").append(this.toIndentedString(this.easing)).append("\n");
        sb.append("    repeatCount: ").append(this.toIndentedString(this.repeatCount)).append("\n");
        sb.append("    repeatMode: ").append(this.toIndentedString((Object)this.repeatMode)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String delay;
        private String description;
        private Boolean screenLock;
        private String sequencer;
        private Boolean when;
        private String componentId;
        private String duration;
        private String easing;
        private String repeatCount;
        private AnimateItemRepeatMode repeatMode;
        private List<AnimatedProperty> value;

        private Builder() {
        }

        @JsonProperty(value="delay")
        public Builder withDelay(Integer delay) {
            this.delay = String.valueOf(delay);
            return this;
        }

        public Builder withDelay(String delayExpression) {
            this.delay = delayExpression;
            return this;
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="screenLock")
        public Builder withScreenLock(Boolean screenLock) {
            this.screenLock = screenLock;
            return this;
        }

        @JsonProperty(value="sequencer")
        public Builder withSequencer(String sequencer) {
            this.sequencer = sequencer;
            return this;
        }

        @JsonProperty(value="when")
        public Builder withWhen(Boolean when) {
            this.when = when;
            return this;
        }

        @JsonProperty(value="componentId")
        public Builder withComponentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(Integer duration) {
            this.duration = String.valueOf(duration);
            return this;
        }

        public Builder withDuration(String durationExpression) {
            this.duration = durationExpression;
            return this;
        }

        @JsonProperty(value="easing")
        public Builder withEasing(String easing) {
            this.easing = easing;
            return this;
        }

        @JsonProperty(value="repeatCount")
        public Builder withRepeatCount(Integer repeatCount) {
            this.repeatCount = String.valueOf(repeatCount);
            return this;
        }

        public Builder withRepeatCount(String repeatCountExpression) {
            this.repeatCount = repeatCountExpression;
            return this;
        }

        @JsonProperty(value="repeatMode")
        public Builder withRepeatMode(AnimateItemRepeatMode repeatMode) {
            this.repeatMode = repeatMode;
            return this;
        }

        @JsonProperty(value="value")
        public Builder withValue(List<AnimatedProperty> value) {
            this.value = value;
            return this;
        }

        public Builder addValueItem(AnimatedProperty valueItem) {
            if (this.value == null) {
                this.value = new ArrayList<AnimatedProperty>();
            }
            this.value.add(valueItem);
            return this;
        }

        public AnimateItemCommand build() {
            return new AnimateItemCommand(this);
        }
    }
}

