/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.IntentConfirmationStatus;
import com.amazon.ask.model.Slot;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Intent {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="slots")
    private Map<String, Slot> slots = new HashMap<String, Slot>();
    @JsonProperty(value="confirmationStatus")
    private String confirmationStatus = null;

    public static Builder builder() {
        return new Builder();
    }

    private Intent(Builder builder) {
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.slots != null) {
            this.slots = builder.slots;
        }
        if (builder.confirmationStatus != null) {
            this.confirmationStatus = builder.confirmationStatus;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="slots")
    public Map<String, Slot> getSlots() {
        return this.slots;
    }

    public IntentConfirmationStatus getConfirmationStatus() {
        return IntentConfirmationStatus.fromValue(this.confirmationStatus);
    }

    @JsonProperty(value="confirmationStatus")
    public String getConfirmationStatusAsString() {
        return this.confirmationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Intent intent = (Intent)o;
        return Objects.equals(this.name, intent.name) && Objects.equals(this.slots, intent.slots) && Objects.equals(this.confirmationStatus, intent.confirmationStatus);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.slots, this.confirmationStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Intent {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    slots: ").append(this.toIndentedString(this.slots)).append("\n");
        sb.append("    confirmationStatus: ").append(this.toIndentedString(this.confirmationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private Map<String, Slot> slots;
        private String confirmationStatus;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="slots")
        public Builder withSlots(Map<String, Slot> slots) {
            this.slots = slots;
            return this;
        }

        public Builder putSlotsItem(String key, Slot slotsItem) {
            if (this.slots == null) {
                this.slots = new HashMap<String, Slot>();
            }
            this.slots.put(key, slotsItem);
            return this;
        }

        @JsonProperty(value="confirmationStatus")
        public Builder withConfirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        public Builder withConfirmationStatus(IntentConfirmationStatus confirmationStatus) {
            this.confirmationStatus = confirmationStatus != null ? confirmationStatus.toString() : null;
            return this;
        }

        public Intent build() {
            return new Intent(this);
        }
    }
}

