/*
* Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file
* except in compliance with the License. A copy of the License is located at
*
* http://aws.amazon.com/apache2.0/
*
* or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for
* the specific language governing permissions and limitations under the License.
*/


package com.amazon.ask.model.interfaces.alexa.presentation.apl.listoperations;

import java.util.Objects;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Deletes items at consecutive indexes in a dynamicIndexList.
 */

@JsonDeserialize(builder = DeleteMultipleItemsOperation.Builder.class)
public final class DeleteMultipleItemsOperation extends com.amazon.ask.model.interfaces.alexa.presentation.apl.listoperations.Operation  {

    @JsonProperty("count")
    private Integer count = null;

    public static Builder builder() {
        return new Builder();
    }

    private DeleteMultipleItemsOperation(Builder builder) {
        String discriminatorValue = "DeleteMultipleItems";

        this.type = discriminatorValue;
        if (builder.index != null) {
            this.index = builder.index;
        }
        if (builder.count != null) {
            this.count = builder.count;
        }
    }

    /**
     * The number of items to delete.
     * @return count
    **/
    @JsonProperty("count")
    public Integer getCount() {
        return count;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeleteMultipleItemsOperation interfacesAlexaPresentationAplListoperationsDeleteMultipleItemsOperation = (DeleteMultipleItemsOperation) o;
        return Objects.equals(this.count, interfacesAlexaPresentationAplListoperationsDeleteMultipleItemsOperation.count) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(count, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteMultipleItemsOperation {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    count: ").append(toIndentedString(count)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
  
    public static class Builder {
        private Integer index;
        private Integer count;

        private Builder() {}

        @JsonProperty("index")

        public Builder withIndex(Integer index) {
            this.index = index;
            return this;
        }


        @JsonProperty("count")

        public Builder withCount(Integer count) {
            this.count = count;
            return this;
        }


        public DeleteMultipleItemsOperation build() {
            return new DeleteMultipleItemsOperation(this);
        }
    }
}

