/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.ups;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.ups.DistanceUnits;
import com.amazon.ask.model.services.ups.Error;
import com.amazon.ask.model.services.ups.PhoneNumber;
import com.amazon.ask.model.services.ups.TemperatureUnit;
import com.amazon.ask.model.services.ups.UpsService;
import java.util.ArrayList;
import java.util.HashMap;

public class UpsServiceClient
extends BaseServiceClient
implements UpsService {
    public UpsServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public String getProfileEmail() throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v2/accounts/~current/settings/Profile.email";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        return (String)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class);
    }

    @Override
    public String getProfileGivenName() throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v2/accounts/~current/settings/Profile.givenName";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        return (String)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class);
    }

    @Override
    public PhoneNumber getProfileMobileNumber() throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v2/accounts/~current/settings/Profile.mobileNumber";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(PhoneNumber.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        return (PhoneNumber)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, PhoneNumber.class);
    }

    @Override
    public String getProfileName() throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v2/accounts/~current/settings/Profile.name";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully retrieved the requested information."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        return (String)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class);
    }

    @Override
    public DistanceUnits getSystemDistanceUnits(String deviceId) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("deviceId", deviceId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v2/devices/{deviceId}/settings/System.distanceUnits";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(DistanceUnits.class, 200, "Successfully get the setting"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        return (DistanceUnits)((Object)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, DistanceUnits.class));
    }

    @Override
    public TemperatureUnit getSystemTemperatureUnit(String deviceId) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("deviceId", deviceId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v2/devices/{deviceId}/settings/System.temperatureUnit";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(TemperatureUnit.class, 200, "Successfully get the setting"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        return (TemperatureUnit)((Object)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, TemperatureUnit.class));
    }

    @Override
    public String getSystemTimeZone(String deviceId) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("deviceId", deviceId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v2/devices/{deviceId}/settings/System.timeZone";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(String.class, 200, "Successfully get the setting"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 204, "The query did not return any results."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is malformed or invalid."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token does not have access to resource."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The skill has been throttled due to an excessive number of requests."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "An unexpected error occurred."));
        return (String)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, String.class);
    }
}

