/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.skillMessaging;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.AuthenticationConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.lwa.LwaClient;
import com.amazon.ask.model.services.skillMessaging.Error;
import com.amazon.ask.model.services.skillMessaging.SendSkillMessagingRequest;
import com.amazon.ask.model.services.skillMessaging.SkillMessagingService;
import java.util.ArrayList;
import java.util.HashMap;

public class SkillMessagingServiceClient
extends BaseServiceClient
implements SkillMessagingService {
    private final LwaClient lwaClient;

    public SkillMessagingServiceClient(ApiConfiguration apiConfiguration, AuthenticationConfiguration authenticationConfiguration) {
        super(apiConfiguration);
        this.lwaClient = LwaClient.builder().withAuthenticationConfiguration(authenticationConfiguration).withApiConfiguration(apiConfiguration).build();
    }

    @Override
    public void sendSkillMessage(String userId, SendSkillMessagingRequest sendSkillMessagingRequest) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("userId", userId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String accessToken = this.lwaClient.getAccessTokenForScope("alexa:skill_messaging");
        headerParams.add(new Pair<String, String>("Authorization", "Bearer " + accessToken));
        String path = "/v1/skillmessages/users/{userId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 202, "Message has been successfully accepted, and will be sent to the skill "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Data is missing or not valid "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The skill messaging authentication token is expired or not valid "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "The passed userId does not exist "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The requester has exceeded their maximum allowable rate of messages "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "The SkillMessaging service encountered an internal error for a valid request. "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Unexpected error"));
        this.invoke("POST", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, sendSkillMessagingRequest, null);
    }
}

