/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.reminderManagement.AlertInfo;
import com.amazon.ask.model.services.reminderManagement.PushNotification;
import com.amazon.ask.model.services.reminderManagement.Trigger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ReminderRequest {
    @JsonProperty(value="requestTime")
    private OffsetDateTime requestTime = null;
    @JsonProperty(value="trigger")
    private Trigger trigger = null;
    @JsonProperty(value="alertInfo")
    private AlertInfo alertInfo = null;
    @JsonProperty(value="pushNotification")
    private PushNotification pushNotification = null;

    public static Builder builder() {
        return new Builder();
    }

    private ReminderRequest(Builder builder) {
        this.requestTime = builder.requestTime;
        this.trigger = builder.trigger;
        this.alertInfo = builder.alertInfo;
        this.pushNotification = builder.pushNotification;
    }

    public OffsetDateTime getRequestTime() {
        return this.requestTime;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public AlertInfo getAlertInfo() {
        return this.alertInfo;
    }

    public PushNotification getPushNotification() {
        return this.pushNotification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReminderRequest servicesReminderManagementReminderRequest = (ReminderRequest)o;
        return Objects.equals(this.requestTime, servicesReminderManagementReminderRequest.requestTime) && Objects.equals(this.trigger, servicesReminderManagementReminderRequest.trigger) && Objects.equals(this.alertInfo, servicesReminderManagementReminderRequest.alertInfo) && Objects.equals(this.pushNotification, servicesReminderManagementReminderRequest.pushNotification);
    }

    public int hashCode() {
        return Objects.hash(this.requestTime, this.trigger, this.alertInfo, this.pushNotification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReminderRequest {\n");
        sb.append("    requestTime: ").append(this.toIndentedString(this.requestTime)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString(this.trigger)).append("\n");
        sb.append("    alertInfo: ").append(this.toIndentedString(this.alertInfo)).append("\n");
        sb.append("    pushNotification: ").append(this.toIndentedString(this.pushNotification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private OffsetDateTime requestTime;
        private Trigger trigger;
        private AlertInfo alertInfo;
        private PushNotification pushNotification;

        private Builder() {
        }

        @JsonProperty(value="requestTime")
        public Builder withRequestTime(OffsetDateTime requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        @JsonProperty(value="trigger")
        public Builder withTrigger(Trigger trigger) {
            this.trigger = trigger;
            return this;
        }

        @JsonProperty(value="alertInfo")
        public Builder withAlertInfo(AlertInfo alertInfo) {
            this.alertInfo = alertInfo;
            return this;
        }

        @JsonProperty(value="pushNotification")
        public Builder withPushNotification(PushNotification pushNotification) {
            this.pushNotification = pushNotification;
            return this;
        }

        public ReminderRequest build() {
            return new ReminderRequest(this);
        }
    }
}

