/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.reminderManagement.Error;
import com.amazon.ask.model.services.reminderManagement.GetReminderResponse;
import com.amazon.ask.model.services.reminderManagement.GetRemindersResponse;
import com.amazon.ask.model.services.reminderManagement.ReminderManagementService;
import com.amazon.ask.model.services.reminderManagement.ReminderRequest;
import com.amazon.ask.model.services.reminderManagement.ReminderResponse;
import java.util.ArrayList;
import java.util.HashMap;

public class ReminderManagementServiceClient
extends BaseServiceClient
implements ReminderManagementService {
    public ReminderManagementServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public void deleteReminder(String alertToken) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("alertToken", alertToken);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v1/alerts/reminders/{alertToken}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "UserAuthenticationException. Request is not authorized/authenticated e.g. If customer does not have permission to create a reminder."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        this.invoke("DELETE", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null);
    }

    @Override
    public GetReminderResponse getReminder(String alertToken) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("alertToken", alertToken);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v1/alerts/reminders/{alertToken}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(GetReminderResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "UserAuthenticationException. Request is not authorized/authenticated e.g. If customer does not have permission to create a reminder."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        return (GetReminderResponse)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, GetReminderResponse.class);
    }

    @Override
    public ReminderResponse updateReminder(String alertToken, ReminderRequest reminderRequest) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("alertToken", alertToken);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v1/alerts/reminders/{alertToken}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(ReminderResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "NotFoundException e.g. Retured when reminder is not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "UserAuthenticationException. Request is not authorized/authenticated e.g. If customer does not have permission to create a reminder."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        return (ReminderResponse)this.invoke("PUT", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, reminderRequest, ReminderResponse.class);
    }

    @Override
    public GetRemindersResponse getReminders() throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v1/alerts/reminders/";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(GetRemindersResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "UserAuthenticationException. Request is not authorized/authenticated e.g. If customer does not have permission to create a reminder."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        return (GetRemindersResponse)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, GetRemindersResponse.class);
    }

    @Override
    public ReminderResponse createReminder(ReminderRequest reminderRequest) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v1/alerts/reminders/";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(ReminderResponse.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "RateExceededException e.g. When the skill is throttled for exceeding the max rate"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 503, "Service Unavailable"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 504, "Gateway Timeout"));
        return (ReminderResponse)this.invoke("POST", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, reminderRequest, ReminderResponse.class);
    }
}

