/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.reminderManagement.RecurrenceDay;
import com.amazon.ask.model.services.reminderManagement.RecurrenceFreq;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Recurrence {
    @JsonProperty(value="freq")
    private RecurrenceFreq freq = null;
    @JsonProperty(value="byDay")
    private List<RecurrenceDay> byDay = new ArrayList<RecurrenceDay>();
    @JsonProperty(value="interval")
    private Integer interval = null;

    public static Builder builder() {
        return new Builder();
    }

    private Recurrence(Builder builder) {
        this.freq = builder.freq;
        this.byDay = builder.byDay;
        this.interval = builder.interval;
    }

    public RecurrenceFreq getFreq() {
        return this.freq;
    }

    public List<RecurrenceDay> getByDay() {
        return this.byDay;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recurrence servicesReminderManagementRecurrence = (Recurrence)o;
        return Objects.equals((Object)this.freq, (Object)servicesReminderManagementRecurrence.freq) && Objects.equals(this.byDay, servicesReminderManagementRecurrence.byDay) && Objects.equals(this.interval, servicesReminderManagementRecurrence.interval);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.freq, this.byDay, this.interval});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recurrence {\n");
        sb.append("    freq: ").append(this.toIndentedString((Object)this.freq)).append("\n");
        sb.append("    byDay: ").append(this.toIndentedString(this.byDay)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private RecurrenceFreq freq;
        private List<RecurrenceDay> byDay;
        private Integer interval;

        private Builder() {
        }

        @JsonProperty(value="freq")
        public Builder withFreq(RecurrenceFreq freq) {
            this.freq = freq;
            return this;
        }

        @JsonProperty(value="byDay")
        public Builder withByDay(List<RecurrenceDay> byDay) {
            this.byDay = byDay;
            return this;
        }

        public Builder addByDayItem(RecurrenceDay byDayItem) {
            if (this.byDay == null) {
                this.byDay = new ArrayList<RecurrenceDay>();
            }
            this.byDay.add(byDayItem);
            return this;
        }

        @JsonProperty(value="interval")
        public Builder withInterval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public Recurrence build() {
            return new Recurrence(this);
        }
    }
}

