/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.reminderManagement.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Event {
    @JsonProperty(value="status")
    private Status status = null;
    @JsonProperty(value="alertToken")
    private String alertToken = null;

    public static Builder builder() {
        return new Builder();
    }

    private Event(Builder builder) {
        this.status = builder.status;
        this.alertToken = builder.alertToken;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getAlertToken() {
        return this.alertToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event servicesReminderManagementEvent = (Event)o;
        return Objects.equals((Object)this.status, (Object)servicesReminderManagementEvent.status) && Objects.equals(this.alertToken, servicesReminderManagementEvent.alertToken);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.alertToken});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    alertToken: ").append(this.toIndentedString(this.alertToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Status status;
        private String alertToken;

        private Builder() {
        }

        @JsonProperty(value="status")
        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="alertToken")
        public Builder withAlertToken(String alertToken) {
            this.alertToken = alertToken;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

