/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.proactiveEvents;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.AuthenticationConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.lwa.LwaClient;
import com.amazon.ask.model.services.proactiveEvents.CreateProactiveEventRequest;
import com.amazon.ask.model.services.proactiveEvents.Error;
import com.amazon.ask.model.services.proactiveEvents.ProactiveEventsService;
import com.amazon.ask.model.services.proactiveEvents.SkillStage;
import java.util.ArrayList;
import java.util.HashMap;

public class ProactiveEventsServiceClient
extends BaseServiceClient
implements ProactiveEventsService {
    private final LwaClient lwaClient;

    public ProactiveEventsServiceClient(ApiConfiguration apiConfiguration, AuthenticationConfiguration authenticationConfiguration) {
        super(apiConfiguration);
        this.lwaClient = LwaClient.builder().withAuthenticationConfiguration(authenticationConfiguration).withApiConfiguration(apiConfiguration).build();
    }

    @Override
    public void createProactiveEvent(CreateProactiveEventRequest createProactiveEventRequest, SkillStage stage) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String accessToken = this.lwaClient.getAccessTokenForScope("alexa::proactive_events");
        headerParams.add(new Pair<String, String>("Authorization", "Bearer " + accessToken));
        String path = "/v1/proactiveEvents";
        if (stage == SkillStage.DEVELOPMENT) {
            path = path + "/stages/development";
        }
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 202, "Request accepted"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "A required parameter is not present or is incorrectly formatted, or the requested creation of a resource has already been completed by a previous request. "));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token is invalid or doesn't have authentication to access the resource"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "A skill attempts to create duplicate events using the same referenceId for the same customer."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The client has made more calls than the allowed limit."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "The ProactiveEvents service encounters an internal error for a valid request."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Unexpected error"));
        this.invoke("POST", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, createProactiveEventRequest, null);
    }
}

