/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.monetization;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.monetization.Error;
import com.amazon.ask.model.services.monetization.InSkillProduct;
import com.amazon.ask.model.services.monetization.InSkillProductsResponse;
import com.amazon.ask.model.services.monetization.MonetizationService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class MonetizationServiceClient
extends BaseServiceClient
implements MonetizationService {
    public MonetizationServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public InSkillProductsResponse getInSkillProducts(String acceptLanguage, String purchasable, String entitled, String productType, String nextToken, BigDecimal maxResults) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        if (purchasable != null) {
            queryParams.add(new Pair<String, String>("purchasable", purchasable));
        }
        if (entitled != null) {
            queryParams.add(new Pair<String, String>("entitled", entitled));
        }
        if (productType != null) {
            queryParams.add(new Pair<String, String>("productType", productType));
        }
        if (nextToken != null) {
            queryParams.add(new Pair<String, String>("nextToken", nextToken));
        }
        if (maxResults != null) {
            queryParams.add(new Pair<String, String>("maxResults", maxResults.toString()));
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        if (acceptLanguage != null) {
            headerParams.add(new Pair<String, String>("Accept-Language", acceptLanguage));
        }
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v1/users/~current/skills/~current/inSkillProducts";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(InSkillProductsResponse.class, 200, "Returns a list of In-Skill products on success."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Invalid request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is invalid or doesn't have access to make this request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        return (InSkillProductsResponse)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, InSkillProductsResponse.class);
    }

    @Override
    public InSkillProduct getInSkillProduct(String acceptLanguage, String productId) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("productId", productId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        if (acceptLanguage != null) {
            headerParams.add(new Pair<String, String>("Accept-Language", acceptLanguage));
        }
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        String path = "/v1/users/~current/skills/~current/inSkillProducts/{productId}";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(InSkillProduct.class, 200, "Returns an In-Skill Product on success."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Invalid request."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "The authentication token is invalid or doesn't have access to make this request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Requested resource not found."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error."));
        return (InSkillProduct)this.invoke("GET", this.apiEndpoint, path, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, InSkillProduct.class);
    }
}

