/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.monetization;

import com.amazon.ask.model.services.monetization.EntitledState;
import com.amazon.ask.model.services.monetization.EntitlementReason;
import com.amazon.ask.model.services.monetization.ProductType;
import com.amazon.ask.model.services.monetization.PurchasableState;
import com.amazon.ask.model.services.monetization.PurchaseMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class InSkillProduct {
    @JsonProperty(value="productId")
    private String productId = null;
    @JsonProperty(value="referenceName")
    private String referenceName = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private ProductType type = null;
    @JsonProperty(value="summary")
    private String summary = null;
    @JsonProperty(value="purchasable")
    private PurchasableState purchasable = null;
    @JsonProperty(value="entitled")
    private EntitledState entitled = null;
    @JsonProperty(value="entitlementReason")
    private EntitlementReason entitlementReason = null;
    @JsonProperty(value="activeEntitlementCount")
    private Integer activeEntitlementCount = null;
    @JsonProperty(value="purchaseMode")
    private PurchaseMode purchaseMode = null;

    public static Builder builder() {
        return new Builder();
    }

    private InSkillProduct(Builder builder) {
        this.productId = builder.productId;
        this.referenceName = builder.referenceName;
        this.name = builder.name;
        this.type = builder.type;
        this.summary = builder.summary;
        this.purchasable = builder.purchasable;
        this.entitled = builder.entitled;
        this.entitlementReason = builder.entitlementReason;
        this.activeEntitlementCount = builder.activeEntitlementCount;
        this.purchaseMode = builder.purchaseMode;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public String getName() {
        return this.name;
    }

    public ProductType getType() {
        return this.type;
    }

    public String getSummary() {
        return this.summary;
    }

    public PurchasableState getPurchasable() {
        return this.purchasable;
    }

    public EntitledState getEntitled() {
        return this.entitled;
    }

    public EntitlementReason getEntitlementReason() {
        return this.entitlementReason;
    }

    public Integer getActiveEntitlementCount() {
        return this.activeEntitlementCount;
    }

    public PurchaseMode getPurchaseMode() {
        return this.purchaseMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InSkillProduct servicesMonetizationInSkillProduct = (InSkillProduct)o;
        return Objects.equals(this.productId, servicesMonetizationInSkillProduct.productId) && Objects.equals(this.referenceName, servicesMonetizationInSkillProduct.referenceName) && Objects.equals(this.name, servicesMonetizationInSkillProduct.name) && Objects.equals((Object)this.type, (Object)servicesMonetizationInSkillProduct.type) && Objects.equals(this.summary, servicesMonetizationInSkillProduct.summary) && Objects.equals((Object)this.purchasable, (Object)servicesMonetizationInSkillProduct.purchasable) && Objects.equals((Object)this.entitled, (Object)servicesMonetizationInSkillProduct.entitled) && Objects.equals((Object)this.entitlementReason, (Object)servicesMonetizationInSkillProduct.entitlementReason) && Objects.equals(this.activeEntitlementCount, servicesMonetizationInSkillProduct.activeEntitlementCount) && Objects.equals((Object)this.purchaseMode, (Object)servicesMonetizationInSkillProduct.purchaseMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.productId, this.referenceName, this.name, this.type, this.summary, this.purchasable, this.entitled, this.entitlementReason, this.activeEntitlementCount, this.purchaseMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InSkillProduct {\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    referenceName: ").append(this.toIndentedString(this.referenceName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    purchasable: ").append(this.toIndentedString((Object)this.purchasable)).append("\n");
        sb.append("    entitled: ").append(this.toIndentedString((Object)this.entitled)).append("\n");
        sb.append("    entitlementReason: ").append(this.toIndentedString((Object)this.entitlementReason)).append("\n");
        sb.append("    activeEntitlementCount: ").append(this.toIndentedString(this.activeEntitlementCount)).append("\n");
        sb.append("    purchaseMode: ").append(this.toIndentedString((Object)this.purchaseMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String productId;
        private String referenceName;
        private String name;
        private ProductType type;
        private String summary;
        private PurchasableState purchasable;
        private EntitledState entitled;
        private EntitlementReason entitlementReason;
        private Integer activeEntitlementCount;
        private PurchaseMode purchaseMode;

        private Builder() {
        }

        @JsonProperty(value="productId")
        public Builder withProductId(String productId) {
            this.productId = productId;
            return this;
        }

        @JsonProperty(value="referenceName")
        public Builder withReferenceName(String referenceName) {
            this.referenceName = referenceName;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(ProductType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="summary")
        public Builder withSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @JsonProperty(value="purchasable")
        public Builder withPurchasable(PurchasableState purchasable) {
            this.purchasable = purchasable;
            return this;
        }

        @JsonProperty(value="entitled")
        public Builder withEntitled(EntitledState entitled) {
            this.entitled = entitled;
            return this;
        }

        @JsonProperty(value="entitlementReason")
        public Builder withEntitlementReason(EntitlementReason entitlementReason) {
            this.entitlementReason = entitlementReason;
            return this;
        }

        @JsonProperty(value="activeEntitlementCount")
        public Builder withActiveEntitlementCount(Integer activeEntitlementCount) {
            this.activeEntitlementCount = activeEntitlementCount;
            return this;
        }

        @JsonProperty(value="purchaseMode")
        public Builder withPurchaseMode(PurchaseMode purchaseMode) {
            this.purchaseMode = purchaseMode;
            return this;
        }

        public InSkillProduct build() {
            return new InSkillProduct(this);
        }
    }
}

