/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.listManagement.ListItemState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class UpdateListItemRequest {
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="status")
    private ListItemState status = null;
    @JsonProperty(value="version")
    private Long version = null;

    public static Builder builder() {
        return new Builder();
    }

    private UpdateListItemRequest(Builder builder) {
        this.value = builder.value;
        this.status = builder.status;
        this.version = builder.version;
    }

    public String getValue() {
        return this.value;
    }

    public ListItemState getStatus() {
        return this.status;
    }

    public Long getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateListItemRequest servicesListManagementUpdateListItemRequest = (UpdateListItemRequest)o;
        return Objects.equals(this.value, servicesListManagementUpdateListItemRequest.value) && Objects.equals((Object)this.status, (Object)servicesListManagementUpdateListItemRequest.status) && Objects.equals(this.version, servicesListManagementUpdateListItemRequest.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.status, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateListItemRequest {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String value;
        private ListItemState status;
        private Long version;

        private Builder() {
        }

        @JsonProperty(value="value")
        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(ListItemState status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        public UpdateListItemRequest build() {
            return new UpdateListItemRequest(this);
        }
    }
}

