/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.listManagement.AlexaListItem;
import com.amazon.ask.model.services.listManagement.Links;
import com.amazon.ask.model.services.listManagement.ListState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AlexaList {
    @JsonProperty(value="listId")
    private String listId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="state")
    private ListState state = null;
    @JsonProperty(value="version")
    private Long version = null;
    @JsonProperty(value="items")
    private List<AlexaListItem> items = new ArrayList<AlexaListItem>();
    @JsonProperty(value="links")
    private Links links = null;

    public static Builder builder() {
        return new Builder();
    }

    private AlexaList(Builder builder) {
        this.listId = builder.listId;
        this.name = builder.name;
        this.state = builder.state;
        this.version = builder.version;
        this.items = builder.items;
        this.links = builder.links;
    }

    public String getListId() {
        return this.listId;
    }

    public String getName() {
        return this.name;
    }

    public ListState getState() {
        return this.state;
    }

    public Long getVersion() {
        return this.version;
    }

    public List<AlexaListItem> getItems() {
        return this.items;
    }

    public Links getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlexaList servicesListManagementAlexaList = (AlexaList)o;
        return Objects.equals(this.listId, servicesListManagementAlexaList.listId) && Objects.equals(this.name, servicesListManagementAlexaList.name) && Objects.equals((Object)this.state, (Object)servicesListManagementAlexaList.state) && Objects.equals(this.version, servicesListManagementAlexaList.version) && Objects.equals(this.items, servicesListManagementAlexaList.items) && Objects.equals(this.links, servicesListManagementAlexaList.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.listId, this.name, this.state, this.version, this.items, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlexaList {\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String listId;
        private String name;
        private ListState state;
        private Long version;
        private List<AlexaListItem> items;
        private Links links;

        private Builder() {
        }

        @JsonProperty(value="listId")
        public Builder withListId(String listId) {
            this.listId = listId;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="state")
        public Builder withState(ListState state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="items")
        public Builder withItems(List<AlexaListItem> items) {
            this.items = items;
            return this;
        }

        public Builder addItemsItem(AlexaListItem itemsItem) {
            if (this.items == null) {
                this.items = new ArrayList<AlexaListItem>();
            }
            this.items.add(itemsItem);
            return this;
        }

        @JsonProperty(value="links")
        public Builder withLinks(Links links) {
            this.links = links;
            return this;
        }

        public AlexaList build() {
            return new AlexaList(this);
        }
    }
}

