/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.gameEngine;

import com.amazon.ask.model.services.gameEngine.Pattern;
import com.amazon.ask.model.services.gameEngine.PatternRecognizerAnchorType;
import com.amazon.ask.model.services.gameEngine.Recognizer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PatternRecognizer
extends Recognizer {
    @JsonProperty(value="anchor")
    private PatternRecognizerAnchorType anchor = null;
    @JsonProperty(value="fuzzy")
    private Boolean fuzzy = null;
    @JsonProperty(value="gadgetIds")
    private List<String> gadgetIds = new ArrayList<String>();
    @JsonProperty(value="actions")
    private List<String> actions = new ArrayList<String>();
    @JsonProperty(value="pattern")
    private List<Pattern> pattern = new ArrayList<Pattern>();

    public static Builder builder() {
        return new Builder();
    }

    private PatternRecognizer(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "match";
        this.anchor = builder.anchor;
        this.fuzzy = builder.fuzzy;
        this.gadgetIds = builder.gadgetIds;
        this.actions = builder.actions;
        this.pattern = builder.pattern;
    }

    public PatternRecognizerAnchorType getAnchor() {
        return this.anchor;
    }

    public Boolean getFuzzy() {
        return this.fuzzy;
    }

    public List<String> getGadgetIds() {
        return this.gadgetIds;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public List<Pattern> getPattern() {
        return this.pattern;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternRecognizer servicesGameEnginePatternRecognizer = (PatternRecognizer)o;
        return Objects.equals((Object)this.anchor, (Object)servicesGameEnginePatternRecognizer.anchor) && Objects.equals(this.fuzzy, servicesGameEnginePatternRecognizer.fuzzy) && Objects.equals(this.gadgetIds, servicesGameEnginePatternRecognizer.gadgetIds) && Objects.equals(this.actions, servicesGameEnginePatternRecognizer.actions) && Objects.equals(this.pattern, servicesGameEnginePatternRecognizer.pattern) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.anchor, this.fuzzy, this.gadgetIds, this.actions, this.pattern, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatternRecognizer {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    anchor: ").append(this.toIndentedString((Object)this.anchor)).append("\n");
        sb.append("    fuzzy: ").append(this.toIndentedString(this.fuzzy)).append("\n");
        sb.append("    gadgetIds: ").append(this.toIndentedString(this.gadgetIds)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private PatternRecognizerAnchorType anchor;
        private Boolean fuzzy;
        private List<String> gadgetIds;
        private List<String> actions;
        private List<Pattern> pattern;

        private Builder() {
        }

        @JsonProperty(value="anchor")
        public Builder withAnchor(PatternRecognizerAnchorType anchor) {
            this.anchor = anchor;
            return this;
        }

        @JsonProperty(value="fuzzy")
        public Builder withFuzzy(Boolean fuzzy) {
            this.fuzzy = fuzzy;
            return this;
        }

        @JsonProperty(value="gadgetIds")
        public Builder withGadgetIds(List<String> gadgetIds) {
            this.gadgetIds = gadgetIds;
            return this;
        }

        public Builder addGadgetIdsItem(String gadgetIdsItem) {
            if (this.gadgetIds == null) {
                this.gadgetIds = new ArrayList<String>();
            }
            this.gadgetIds.add(gadgetIdsItem);
            return this;
        }

        @JsonProperty(value="actions")
        public Builder withActions(List<String> actions) {
            this.actions = actions;
            return this;
        }

        public Builder addActionsItem(String actionsItem) {
            if (this.actions == null) {
                this.actions = new ArrayList<String>();
            }
            this.actions.add(actionsItem);
            return this;
        }

        @JsonProperty(value="pattern")
        public Builder withPattern(List<Pattern> pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder addPatternItem(Pattern patternItem) {
            if (this.pattern == null) {
                this.pattern = new ArrayList<Pattern>();
            }
            this.pattern.add(patternItem);
            return this;
        }

        public PatternRecognizer build() {
            return new PatternRecognizer(this);
        }
    }
}

